/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer.asm;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.shared.dependency.analyzer.DependencyUsage;
import org.objectweb.asm.Type;

public class ResultCollector {
    private final Set<DependencyUsage> classUsages = new HashSet<DependencyUsage>();

    public Set<String> getDependencies() {
        return this.getDependencyUsages().stream().map(DependencyUsage::getDependencyClass).collect(Collectors.toSet());
    }

    public Set<DependencyUsage> getDependencyUsages() {
        return this.classUsages;
    }

    public void addName(String usedByClass, String name) {
        if (name == null) {
            return;
        }
        if (name.charAt(0) == '[') {
            int i = 0;
            while (name.charAt(++i) == '[') {
            }
            if (name.charAt(i) != 'L') {
                return;
            }
            name = name.substring(i + 1, name.length() - 1);
        }
        this.add(usedByClass, name.replace('/', '.'));
    }

    void addDesc(String usedByClass, String desc) {
        this.addType(usedByClass, Type.getType((String)desc));
    }

    void addType(String usedByClass, Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(usedByClass, t.getElementType());
                break;
            }
            case 11: {
                this.addMethodDesc(usedByClass, t.getDescriptor());
                break;
            }
            case 10: {
                this.addName(usedByClass, t.getClassName());
                break;
            }
        }
    }

    public void add(String usedByClass, String name) {
        if (name.indexOf(36) < 0) {
            this.classUsages.add(new DependencyUsage(name, usedByClass));
        }
    }

    void addNames(String usedByClass, String[] names) {
        if (names == null) {
            return;
        }
        for (String name : names) {
            this.addName(usedByClass, name);
        }
    }

    void addMethodDesc(String usedByClass, String desc) {
        Type[] types;
        this.addType(usedByClass, Type.getReturnType((String)desc));
        for (Type type : types = Type.getArgumentTypes((String)desc)) {
            this.addType(usedByClass, type);
        }
    }
}

