/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/quota.proto

package org.apache.rocketmq.shaded.com.google.api;

/**
 *
 *
 * <pre>
 * Bind API methods to metrics. Binding a method to a metric causes that
 * metric's configured quota behaviors to apply to the method call.
 * </pre>
 *
 * Protobuf type {@code google.api.MetricRule}
 */
public final class MetricRule extends org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.MetricRule)
    MetricRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MetricRule.newBuilder() to construct.
  private MetricRule(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MetricRule() {
    selector_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MetricRule();
  }

  @java.lang.Override
  public final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private MetricRule(
      org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              selector_ = s;
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                metricCosts_ =
                    org.apache.rocketmq.shaded.com.google.protobuf.MapField.newMapField(
                        MetricCostsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              org.apache.rocketmq.shaded.com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> metricCosts__ =
                  input.readMessage(
                      MetricCostsDefaultEntryHolder.defaultEntry.getParserForType(),
                      extensionRegistry);
              metricCosts_.getMutableMap().put(metricCosts__.getKey(), metricCosts__.getValue());
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (org.apache.rocketmq.shaded.com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return org.apache.rocketmq.shaded.com.google.api.QuotaProto.internal_static_google_api_MetricRule_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected org.apache.rocketmq.shaded.com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 2:
        return internalGetMetricCosts();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return org.apache.rocketmq.shaded.com.google.api.QuotaProto.internal_static_google_api_MetricRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            org.apache.rocketmq.shaded.com.google.api.MetricRule.class, org.apache.rocketmq.shaded.com.google.api.MetricRule.Builder.class);
  }

  public static final int SELECTOR_FIELD_NUMBER = 1;
  private volatile java.lang.Object selector_;
  /**
   *
   *
   * <pre>
   * Selects the methods to which this rule applies.
   * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
   * </pre>
   *
   * <code>string selector = 1;</code>
   *
   * @return The selector.
   */
  @java.lang.Override
  public java.lang.String getSelector() {
    java.lang.Object ref = selector_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selector_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Selects the methods to which this rule applies.
   * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
   * </pre>
   *
   * <code>string selector = 1;</code>
   *
   * @return The bytes for selector.
   */
  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getSelectorBytes() {
    java.lang.Object ref = selector_;
    if (ref instanceof java.lang.String) {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
          org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selector_ = b;
      return b;
    } else {
      return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRIC_COSTS_FIELD_NUMBER = 2;

  private static final class MetricCostsDefaultEntryHolder {
    static final org.apache.rocketmq.shaded.com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> defaultEntry =
        org.apache.rocketmq.shaded.com.google.protobuf.MapEntry.<java.lang.String, java.lang.Long>newDefaultInstance(
            org.apache.rocketmq.shaded.com.google.api.QuotaProto
                .internal_static_google_api_MetricRule_MetricCostsEntry_descriptor,
            org.apache.rocketmq.shaded.com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            org.apache.rocketmq.shaded.com.google.protobuf.WireFormat.FieldType.INT64,
            0L);
  }

  private org.apache.rocketmq.shaded.com.google.protobuf.MapField<java.lang.String, java.lang.Long> metricCosts_;

  private org.apache.rocketmq.shaded.com.google.protobuf.MapField<java.lang.String, java.lang.Long> internalGetMetricCosts() {
    if (metricCosts_ == null) {
      return org.apache.rocketmq.shaded.com.google.protobuf.MapField.emptyMapField(MetricCostsDefaultEntryHolder.defaultEntry);
    }
    return metricCosts_;
  }

  public int getMetricCostsCount() {
    return internalGetMetricCosts().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Metrics to update when the selected methods are called, and the associated
   * cost applied to each metric.
   * The key of the map is the metric name, and the values are the amount
   * increased for the metric against which the quota limits are defined.
   * The value must not be negative.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; metric_costs = 2;</code>
   */
  @java.lang.Override
  public boolean containsMetricCosts(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMetricCosts().getMap().containsKey(key);
  }
  /** Use {@link #getMetricCostsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Long> getMetricCosts() {
    return getMetricCostsMap();
  }
  /**
   *
   *
   * <pre>
   * Metrics to update when the selected methods are called, and the associated
   * cost applied to each metric.
   * The key of the map is the metric name, and the values are the amount
   * increased for the metric against which the quota limits are defined.
   * The value must not be negative.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; metric_costs = 2;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.Long> getMetricCostsMap() {
    return internalGetMetricCosts().getMap();
  }
  /**
   *
   *
   * <pre>
   * Metrics to update when the selected methods are called, and the associated
   * cost applied to each metric.
   * The key of the map is the metric name, and the values are the amount
   * increased for the metric against which the quota limits are defined.
   * The value must not be negative.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; metric_costs = 2;</code>
   */
  @java.lang.Override
  public long getMetricCostsOrDefault(java.lang.String key, long defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Long> map = internalGetMetricCosts().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Metrics to update when the selected methods are called, and the associated
   * cost applied to each metric.
   * The key of the map is the metric name, and the values are the amount
   * increased for the metric against which the quota limits are defined.
   * The value must not be negative.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; metric_costs = 2;</code>
   */
  @java.lang.Override
  public long getMetricCostsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Long> map = internalGetMetricCosts().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(org.apache.rocketmq.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(selector_)) {
      org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 1, selector_);
    }
    org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetMetricCosts(), MetricCostsDefaultEntryHolder.defaultEntry, 2);
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(selector_)) {
      size += org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(1, selector_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Long> entry :
        internalGetMetricCosts().getMap().entrySet()) {
      org.apache.rocketmq.shaded.com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> metricCosts__ =
          MetricCostsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += org.apache.rocketmq.shaded.com.google.protobuf.CodedOutputStream.computeMessageSize(2, metricCosts__);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof org.apache.rocketmq.shaded.com.google.api.MetricRule)) {
      return super.equals(obj);
    }
    org.apache.rocketmq.shaded.com.google.api.MetricRule other = (org.apache.rocketmq.shaded.com.google.api.MetricRule) obj;

    if (!getSelector().equals(other.getSelector())) return false;
    if (!internalGetMetricCosts().equals(other.internalGetMetricCosts())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SELECTOR_FIELD_NUMBER;
    hash = (53 * hash) + getSelector().hashCode();
    if (!internalGetMetricCosts().getMap().isEmpty()) {
      hash = (37 * hash) + METRIC_COSTS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMetricCosts().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static org.apache.rocketmq.shaded.com.google.api.MetricRule parseFrom(java.nio.ByteBuffer data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.api.MetricRule parseFrom(
      java.nio.ByteBuffer data, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.MetricRule parseFrom(org.apache.rocketmq.shaded.com.google.protobuf.ByteString data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.api.MetricRule parseFrom(
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString data,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.MetricRule parseFrom(byte[] data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.api.MetricRule parseFrom(
      byte[] data, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.MetricRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.api.MetricRule parseFrom(
      java.io.InputStream input, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.MetricRule parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.api.MetricRule parseDelimitedFrom(
      java.io.InputStream input, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.MetricRule parseFrom(org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.api.MetricRule parseFrom(
      org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(org.apache.rocketmq.shaded.com.google.api.MetricRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Bind API methods to metrics. Binding a method to a metric causes that
   * metric's configured quota behaviors to apply to the method call.
   * </pre>
   *
   * Protobuf type {@code google.api.MetricRule}
   */
  public static final class Builder extends org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.MetricRule)
      org.apache.rocketmq.shaded.com.google.api.MetricRuleOrBuilder {
    public static final org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return org.apache.rocketmq.shaded.com.google.api.QuotaProto.internal_static_google_api_MetricRule_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected org.apache.rocketmq.shaded.com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetMetricCosts();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected org.apache.rocketmq.shaded.com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 2:
          return internalGetMutableMetricCosts();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.rocketmq.shaded.com.google.api.QuotaProto.internal_static_google_api_MetricRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.rocketmq.shaded.com.google.api.MetricRule.class, org.apache.rocketmq.shaded.com.google.api.MetricRule.Builder.class);
    }

    // Construct using org.apache.rocketmq.shaded.com.google.api.MetricRule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      selector_ = "";

      internalGetMutableMetricCosts().clear();
      return this;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return org.apache.rocketmq.shaded.com.google.api.QuotaProto.internal_static_google_api_MetricRule_descriptor;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.api.MetricRule getDefaultInstanceForType() {
      return org.apache.rocketmq.shaded.com.google.api.MetricRule.getDefaultInstance();
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.api.MetricRule build() {
      org.apache.rocketmq.shaded.com.google.api.MetricRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.api.MetricRule buildPartial() {
      org.apache.rocketmq.shaded.com.google.api.MetricRule result = new org.apache.rocketmq.shaded.com.google.api.MetricRule(this);
      int from_bitField0_ = bitField0_;
      result.selector_ = selector_;
      result.metricCosts_ = internalGetMetricCosts();
      result.metricCosts_.makeImmutable();
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(org.apache.rocketmq.shaded.com.google.protobuf.Message other) {
      if (other instanceof org.apache.rocketmq.shaded.com.google.api.MetricRule) {
        return mergeFrom((org.apache.rocketmq.shaded.com.google.api.MetricRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(org.apache.rocketmq.shaded.com.google.api.MetricRule other) {
      if (other == org.apache.rocketmq.shaded.com.google.api.MetricRule.getDefaultInstance()) return this;
      if (!other.getSelector().isEmpty()) {
        selector_ = other.selector_;
        onChanged();
      }
      internalGetMutableMetricCosts().mergeFrom(other.internalGetMetricCosts());
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
        org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      org.apache.rocketmq.shaded.com.google.api.MetricRule parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (org.apache.rocketmq.shaded.com.google.api.MetricRule) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object selector_ = "";
    /**
     *
     *
     * <pre>
     * Selects the methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @return The selector.
     */
    public java.lang.String getSelector() {
      java.lang.Object ref = selector_;
      if (!(ref instanceof java.lang.String)) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selector_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Selects the methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @return The bytes for selector.
     */
    public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getSelectorBytes() {
      java.lang.Object ref = selector_;
      if (ref instanceof String) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
            org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selector_ = b;
        return b;
      } else {
        return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Selects the methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @param value The selector to set.
     * @return This builder for chaining.
     */
    public Builder setSelector(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      selector_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Selects the methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelector() {

      selector_ = getDefaultInstance().getSelector();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Selects the methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @param value The bytes for selector to set.
     * @return This builder for chaining.
     */
    public Builder setSelectorBytes(org.apache.rocketmq.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      selector_ = value;
      onChanged();
      return this;
    }

    private org.apache.rocketmq.shaded.com.google.protobuf.MapField<java.lang.String, java.lang.Long> metricCosts_;

    private org.apache.rocketmq.shaded.com.google.protobuf.MapField<java.lang.String, java.lang.Long>
        internalGetMetricCosts() {
      if (metricCosts_ == null) {
        return org.apache.rocketmq.shaded.com.google.protobuf.MapField.emptyMapField(
            MetricCostsDefaultEntryHolder.defaultEntry);
      }
      return metricCosts_;
    }

    private org.apache.rocketmq.shaded.com.google.protobuf.MapField<java.lang.String, java.lang.Long>
        internalGetMutableMetricCosts() {
      onChanged();
      ;
      if (metricCosts_ == null) {
        metricCosts_ =
            org.apache.rocketmq.shaded.com.google.protobuf.MapField.newMapField(MetricCostsDefaultEntryHolder.defaultEntry);
      }
      if (!metricCosts_.isMutable()) {
        metricCosts_ = metricCosts_.copy();
      }
      return metricCosts_;
    }

    public int getMetricCostsCount() {
      return internalGetMetricCosts().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Metrics to update when the selected methods are called, and the associated
     * cost applied to each metric.
     * The key of the map is the metric name, and the values are the amount
     * increased for the metric against which the quota limits are defined.
     * The value must not be negative.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; metric_costs = 2;</code>
     */
    @java.lang.Override
    public boolean containsMetricCosts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMetricCosts().getMap().containsKey(key);
    }
    /** Use {@link #getMetricCostsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Long> getMetricCosts() {
      return getMetricCostsMap();
    }
    /**
     *
     *
     * <pre>
     * Metrics to update when the selected methods are called, and the associated
     * cost applied to each metric.
     * The key of the map is the metric name, and the values are the amount
     * increased for the metric against which the quota limits are defined.
     * The value must not be negative.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; metric_costs = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Long> getMetricCostsMap() {
      return internalGetMetricCosts().getMap();
    }
    /**
     *
     *
     * <pre>
     * Metrics to update when the selected methods are called, and the associated
     * cost applied to each metric.
     * The key of the map is the metric name, and the values are the amount
     * increased for the metric against which the quota limits are defined.
     * The value must not be negative.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; metric_costs = 2;</code>
     */
    @java.lang.Override
    public long getMetricCostsOrDefault(java.lang.String key, long defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Long> map = internalGetMetricCosts().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Metrics to update when the selected methods are called, and the associated
     * cost applied to each metric.
     * The key of the map is the metric name, and the values are the amount
     * increased for the metric against which the quota limits are defined.
     * The value must not be negative.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; metric_costs = 2;</code>
     */
    @java.lang.Override
    public long getMetricCostsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Long> map = internalGetMetricCosts().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMetricCosts() {
      internalGetMutableMetricCosts().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics to update when the selected methods are called, and the associated
     * cost applied to each metric.
     * The key of the map is the metric name, and the values are the amount
     * increased for the metric against which the quota limits are defined.
     * The value must not be negative.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; metric_costs = 2;</code>
     */
    public Builder removeMetricCosts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMetricCosts().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Long> getMutableMetricCosts() {
      return internalGetMutableMetricCosts().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Metrics to update when the selected methods are called, and the associated
     * cost applied to each metric.
     * The key of the map is the metric name, and the values are the amount
     * increased for the metric against which the quota limits are defined.
     * The value must not be negative.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; metric_costs = 2;</code>
     */
    public Builder putMetricCosts(java.lang.String key, long value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableMetricCosts().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics to update when the selected methods are called, and the associated
     * cost applied to each metric.
     * The key of the map is the metric name, and the values are the amount
     * increased for the metric against which the quota limits are defined.
     * The value must not be negative.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; metric_costs = 2;</code>
     */
    public Builder putAllMetricCosts(java.util.Map<java.lang.String, java.lang.Long> values) {
      internalGetMutableMetricCosts().getMutableMap().putAll(values);
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.MetricRule)
  }

  // @@protoc_insertion_point(class_scope:google.api.MetricRule)
  private static final org.apache.rocketmq.shaded.com.google.api.MetricRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new org.apache.rocketmq.shaded.com.google.api.MetricRule();
  }

  public static org.apache.rocketmq.shaded.com.google.api.MetricRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final org.apache.rocketmq.shaded.com.google.protobuf.Parser<MetricRule> PARSER =
      new org.apache.rocketmq.shaded.com.google.protobuf.AbstractParser<MetricRule>() {
        @java.lang.Override
        public MetricRule parsePartialFrom(
            org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
            org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
          return new MetricRule(input, extensionRegistry);
        }
      };

  public static org.apache.rocketmq.shaded.com.google.protobuf.Parser<MetricRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.protobuf.Parser<MetricRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.api.MetricRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
