/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/location/locations.proto

package org.apache.rocketmq.shaded.com.google.cloud.location;

/**
 *
 *
 * <pre>
 * The response message for [Locations.ListLocations][google.cloud.location.Locations.ListLocations].
 * </pre>
 *
 * Protobuf type {@code google.cloud.location.ListLocationsResponse}
 */
public final class ListLocationsResponse extends org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.location.ListLocationsResponse)
    ListLocationsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListLocationsResponse.newBuilder() to construct.
  private ListLocationsResponse(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListLocationsResponse() {
    locations_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListLocationsResponse();
  }

  @java.lang.Override
  public final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ListLocationsResponse(
      org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                locations_ = new java.util.ArrayList<org.apache.rocketmq.shaded.com.google.cloud.location.Location>();
                mutable_bitField0_ |= 0x00000001;
              }
              locations_.add(
                  input.readMessage(
                      org.apache.rocketmq.shaded.com.google.cloud.location.Location.parser(), extensionRegistry));
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              nextPageToken_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (org.apache.rocketmq.shaded.com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        locations_ = java.util.Collections.unmodifiableList(locations_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return org.apache.rocketmq.shaded.com.google.cloud.location.LocationsProto
        .internal_static_google_cloud_location_ListLocationsResponse_descriptor;
  }

  @java.lang.Override
  protected org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return org.apache.rocketmq.shaded.com.google.cloud.location.LocationsProto
        .internal_static_google_cloud_location_ListLocationsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse.class,
            org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse.Builder.class);
  }

  public static final int LOCATIONS_FIELD_NUMBER = 1;
  private java.util.List<org.apache.rocketmq.shaded.com.google.cloud.location.Location> locations_;
  /**
   *
   *
   * <pre>
   * A list of locations that matches the specified filter in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.location.Location locations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<org.apache.rocketmq.shaded.com.google.cloud.location.Location> getLocationsList() {
    return locations_;
  }
  /**
   *
   *
   * <pre>
   * A list of locations that matches the specified filter in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.location.Location locations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends org.apache.rocketmq.shaded.com.google.cloud.location.LocationOrBuilder>
      getLocationsOrBuilderList() {
    return locations_;
  }
  /**
   *
   *
   * <pre>
   * A list of locations that matches the specified filter in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.location.Location locations = 1;</code>
   */
  @java.lang.Override
  public int getLocationsCount() {
    return locations_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of locations that matches the specified filter in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.location.Location locations = 1;</code>
   */
  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.cloud.location.Location getLocations(int index) {
    return locations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of locations that matches the specified filter in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.location.Location locations = 1;</code>
   */
  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.cloud.location.LocationOrBuilder getLocationsOrBuilder(int index) {
    return locations_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;
  private volatile java.lang.Object nextPageToken_;
  /**
   *
   *
   * <pre>
   * The standard List next-page token.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The standard List next-page token.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
          org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(org.apache.rocketmq.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < locations_.size(); i++) {
      output.writeMessage(1, locations_.get(i));
    }
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < locations_.size(); i++) {
      size += org.apache.rocketmq.shaded.com.google.protobuf.CodedOutputStream.computeMessageSize(1, locations_.get(i));
    }
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse)) {
      return super.equals(obj);
    }
    org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse other =
        (org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse) obj;

    if (!getLocationsList().equals(other.getLocationsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getLocationsCount() > 0) {
      hash = (37 * hash) + LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getLocationsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse parseFrom(java.nio.ByteBuffer data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse parseFrom(
      java.nio.ByteBuffer data, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse parseFrom(
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse parseFrom(
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString data,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse parseFrom(byte[] data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse parseFrom(
      byte[] data, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse parseFrom(
      java.io.InputStream input, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse parseDelimitedFrom(
      java.io.InputStream input, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse parseFrom(
      org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse parseFrom(
      org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response message for [Locations.ListLocations][google.cloud.location.Locations.ListLocations].
   * </pre>
   *
   * Protobuf type {@code google.cloud.location.ListLocationsResponse}
   */
  public static final class Builder extends org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.location.ListLocationsResponse)
      org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponseOrBuilder {
    public static final org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return org.apache.rocketmq.shaded.com.google.cloud.location.LocationsProto
          .internal_static_google_cloud_location_ListLocationsResponse_descriptor;
    }

    @java.lang.Override
    protected org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.rocketmq.shaded.com.google.cloud.location.LocationsProto
          .internal_static_google_cloud_location_ListLocationsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse.class,
              org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse.Builder.class);
    }

    // Construct using org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLocationsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (locationsBuilder_ == null) {
        locations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        locationsBuilder_.clear();
      }
      nextPageToken_ = "";

      return this;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return org.apache.rocketmq.shaded.com.google.cloud.location.LocationsProto
          .internal_static_google_cloud_location_ListLocationsResponse_descriptor;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse getDefaultInstanceForType() {
      return org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse build() {
      org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse buildPartial() {
      org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse result =
          new org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse(this);
      int from_bitField0_ = bitField0_;
      if (locationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          locations_ = java.util.Collections.unmodifiableList(locations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.locations_ = locations_;
      } else {
        result.locations_ = locationsBuilder_.build();
      }
      result.nextPageToken_ = nextPageToken_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(org.apache.rocketmq.shaded.com.google.protobuf.Message other) {
      if (other instanceof org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse) {
        return mergeFrom((org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse other) {
      if (other == org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse.getDefaultInstance())
        return this;
      if (locationsBuilder_ == null) {
        if (!other.locations_.isEmpty()) {
          if (locations_.isEmpty()) {
            locations_ = other.locations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureLocationsIsMutable();
            locations_.addAll(other.locations_);
          }
          onChanged();
        }
      } else {
        if (!other.locations_.isEmpty()) {
          if (locationsBuilder_.isEmpty()) {
            locationsBuilder_.dispose();
            locationsBuilder_ = null;
            locations_ = other.locations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            locationsBuilder_ =
                org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLocationsFieldBuilder()
                    : null;
          } else {
            locationsBuilder_.addAllMessages(other.locations_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
        org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<org.apache.rocketmq.shaded.com.google.cloud.location.Location> locations_ =
        java.util.Collections.emptyList();

    private void ensureLocationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        locations_ = new java.util.ArrayList<org.apache.rocketmq.shaded.com.google.cloud.location.Location>(locations_);
        bitField0_ |= 0x00000001;
      }
    }

    private org.apache.rocketmq.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
            org.apache.rocketmq.shaded.com.google.cloud.location.Location,
            org.apache.rocketmq.shaded.com.google.cloud.location.Location.Builder,
            org.apache.rocketmq.shaded.com.google.cloud.location.LocationOrBuilder>
        locationsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public java.util.List<org.apache.rocketmq.shaded.com.google.cloud.location.Location> getLocationsList() {
      if (locationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(locations_);
      } else {
        return locationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public int getLocationsCount() {
      if (locationsBuilder_ == null) {
        return locations_.size();
      } else {
        return locationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public org.apache.rocketmq.shaded.com.google.cloud.location.Location getLocations(int index) {
      if (locationsBuilder_ == null) {
        return locations_.get(index);
      } else {
        return locationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public Builder setLocations(int index, org.apache.rocketmq.shaded.com.google.cloud.location.Location value) {
      if (locationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocationsIsMutable();
        locations_.set(index, value);
        onChanged();
      } else {
        locationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public Builder setLocations(
        int index, org.apache.rocketmq.shaded.com.google.cloud.location.Location.Builder builderForValue) {
      if (locationsBuilder_ == null) {
        ensureLocationsIsMutable();
        locations_.set(index, builderForValue.build());
        onChanged();
      } else {
        locationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public Builder addLocations(org.apache.rocketmq.shaded.com.google.cloud.location.Location value) {
      if (locationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocationsIsMutable();
        locations_.add(value);
        onChanged();
      } else {
        locationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public Builder addLocations(int index, org.apache.rocketmq.shaded.com.google.cloud.location.Location value) {
      if (locationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocationsIsMutable();
        locations_.add(index, value);
        onChanged();
      } else {
        locationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public Builder addLocations(org.apache.rocketmq.shaded.com.google.cloud.location.Location.Builder builderForValue) {
      if (locationsBuilder_ == null) {
        ensureLocationsIsMutable();
        locations_.add(builderForValue.build());
        onChanged();
      } else {
        locationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public Builder addLocations(
        int index, org.apache.rocketmq.shaded.com.google.cloud.location.Location.Builder builderForValue) {
      if (locationsBuilder_ == null) {
        ensureLocationsIsMutable();
        locations_.add(index, builderForValue.build());
        onChanged();
      } else {
        locationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public Builder addAllLocations(
        java.lang.Iterable<? extends org.apache.rocketmq.shaded.com.google.cloud.location.Location> values) {
      if (locationsBuilder_ == null) {
        ensureLocationsIsMutable();
        org.apache.rocketmq.shaded.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, locations_);
        onChanged();
      } else {
        locationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public Builder clearLocations() {
      if (locationsBuilder_ == null) {
        locations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        locationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public Builder removeLocations(int index) {
      if (locationsBuilder_ == null) {
        ensureLocationsIsMutable();
        locations_.remove(index);
        onChanged();
      } else {
        locationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public org.apache.rocketmq.shaded.com.google.cloud.location.Location.Builder getLocationsBuilder(int index) {
      return getLocationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public org.apache.rocketmq.shaded.com.google.cloud.location.LocationOrBuilder getLocationsOrBuilder(int index) {
      if (locationsBuilder_ == null) {
        return locations_.get(index);
      } else {
        return locationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public java.util.List<? extends org.apache.rocketmq.shaded.com.google.cloud.location.LocationOrBuilder>
        getLocationsOrBuilderList() {
      if (locationsBuilder_ != null) {
        return locationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(locations_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public org.apache.rocketmq.shaded.com.google.cloud.location.Location.Builder addLocationsBuilder() {
      return getLocationsFieldBuilder()
          .addBuilder(org.apache.rocketmq.shaded.com.google.cloud.location.Location.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public org.apache.rocketmq.shaded.com.google.cloud.location.Location.Builder addLocationsBuilder(int index) {
      return getLocationsFieldBuilder()
          .addBuilder(index, org.apache.rocketmq.shaded.com.google.cloud.location.Location.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of locations that matches the specified filter in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.location.Location locations = 1;</code>
     */
    public java.util.List<org.apache.rocketmq.shaded.com.google.cloud.location.Location.Builder> getLocationsBuilderList() {
      return getLocationsFieldBuilder().getBuilderList();
    }

    private org.apache.rocketmq.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
            org.apache.rocketmq.shaded.com.google.cloud.location.Location,
            org.apache.rocketmq.shaded.com.google.cloud.location.Location.Builder,
            org.apache.rocketmq.shaded.com.google.cloud.location.LocationOrBuilder>
        getLocationsFieldBuilder() {
      if (locationsBuilder_ == null) {
        locationsBuilder_ =
            new org.apache.rocketmq.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
                org.apache.rocketmq.shaded.com.google.cloud.location.Location,
                org.apache.rocketmq.shaded.com.google.cloud.location.Location.Builder,
                org.apache.rocketmq.shaded.com.google.cloud.location.LocationOrBuilder>(
                locations_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        locations_ = null;
      }
      return locationsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * The standard List next-page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The standard List next-page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
            org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The standard List next-page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      nextPageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The standard List next-page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {

      nextPageToken_ = getDefaultInstance().getNextPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The standard List next-page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(org.apache.rocketmq.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      nextPageToken_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.location.ListLocationsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.location.ListLocationsResponse)
  private static final org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse();
  }

  public static org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final org.apache.rocketmq.shaded.com.google.protobuf.Parser<ListLocationsResponse> PARSER =
      new org.apache.rocketmq.shaded.com.google.protobuf.AbstractParser<ListLocationsResponse>() {
        @java.lang.Override
        public ListLocationsResponse parsePartialFrom(
            org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
            org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
          return new ListLocationsResponse(input, extensionRegistry);
        }
      };

  public static org.apache.rocketmq.shaded.com.google.protobuf.Parser<ListLocationsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.protobuf.Parser<ListLocationsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.cloud.location.ListLocationsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
