/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/type/datetime.proto

package org.apache.rocketmq.shaded.com.google.type;

/**
 *
 *
 * <pre>
 * Represents a time zone from the
 * [IANA Time Zone Database](https://www.iana.org/time-zones).
 * </pre>
 *
 * Protobuf type {@code google.type.TimeZone}
 */
public final class TimeZone extends org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.type.TimeZone)
    TimeZoneOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TimeZone.newBuilder() to construct.
  private TimeZone(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TimeZone() {
    id_ = "";
    version_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TimeZone();
  }

  @java.lang.Override
  public final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private TimeZone(
      org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              version_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (org.apache.rocketmq.shaded.com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return org.apache.rocketmq.shaded.com.google.type.DateTimeProto.internal_static_google_type_TimeZone_descriptor;
  }

  @java.lang.Override
  protected org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return org.apache.rocketmq.shaded.com.google.type.DateTimeProto.internal_static_google_type_TimeZone_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            org.apache.rocketmq.shaded.com.google.type.TimeZone.class, org.apache.rocketmq.shaded.com.google.type.TimeZone.Builder.class);
  }

  public static final int ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object id_;
  /**
   *
   *
   * <pre>
   * IANA Time Zone Database time zone, e.g. "America/New_York".
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * IANA Time Zone Database time zone, e.g. "America/New_York".
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
          org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_FIELD_NUMBER = 2;
  private volatile java.lang.Object version_;
  /**
   *
   *
   * <pre>
   * Optional. IANA Time Zone Database version number, e.g. "2019a".
   * </pre>
   *
   * <code>string version = 2;</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. IANA Time Zone Database version number, e.g. "2019a".
   * </pre>
   *
   * <code>string version = 2;</code>
   *
   * @return The bytes for version.
   */
  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
          org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(org.apache.rocketmq.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 2, version_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      size += org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(2, version_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof org.apache.rocketmq.shaded.com.google.type.TimeZone)) {
      return super.equals(obj);
    }
    org.apache.rocketmq.shaded.com.google.type.TimeZone other = (org.apache.rocketmq.shaded.com.google.type.TimeZone) obj;

    if (!getId().equals(other.getId())) return false;
    if (!getVersion().equals(other.getVersion())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static org.apache.rocketmq.shaded.com.google.type.TimeZone parseFrom(java.nio.ByteBuffer data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.type.TimeZone parseFrom(
      java.nio.ByteBuffer data, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.type.TimeZone parseFrom(org.apache.rocketmq.shaded.com.google.protobuf.ByteString data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.type.TimeZone parseFrom(
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString data,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.type.TimeZone parseFrom(byte[] data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.type.TimeZone parseFrom(
      byte[] data, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.type.TimeZone parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.type.TimeZone parseFrom(
      java.io.InputStream input, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.type.TimeZone parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.type.TimeZone parseDelimitedFrom(
      java.io.InputStream input, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.type.TimeZone parseFrom(org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.type.TimeZone parseFrom(
      org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(org.apache.rocketmq.shaded.com.google.type.TimeZone prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a time zone from the
   * [IANA Time Zone Database](https://www.iana.org/time-zones).
   * </pre>
   *
   * Protobuf type {@code google.type.TimeZone}
   */
  public static final class Builder extends org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.type.TimeZone)
      org.apache.rocketmq.shaded.com.google.type.TimeZoneOrBuilder {
    public static final org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return org.apache.rocketmq.shaded.com.google.type.DateTimeProto.internal_static_google_type_TimeZone_descriptor;
    }

    @java.lang.Override
    protected org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.rocketmq.shaded.com.google.type.DateTimeProto.internal_static_google_type_TimeZone_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.rocketmq.shaded.com.google.type.TimeZone.class, org.apache.rocketmq.shaded.com.google.type.TimeZone.Builder.class);
    }

    // Construct using org.apache.rocketmq.shaded.com.google.type.TimeZone.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      id_ = "";

      version_ = "";

      return this;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return org.apache.rocketmq.shaded.com.google.type.DateTimeProto.internal_static_google_type_TimeZone_descriptor;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.type.TimeZone getDefaultInstanceForType() {
      return org.apache.rocketmq.shaded.com.google.type.TimeZone.getDefaultInstance();
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.type.TimeZone build() {
      org.apache.rocketmq.shaded.com.google.type.TimeZone result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.type.TimeZone buildPartial() {
      org.apache.rocketmq.shaded.com.google.type.TimeZone result = new org.apache.rocketmq.shaded.com.google.type.TimeZone(this);
      result.id_ = id_;
      result.version_ = version_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(org.apache.rocketmq.shaded.com.google.protobuf.Message other) {
      if (other instanceof org.apache.rocketmq.shaded.com.google.type.TimeZone) {
        return mergeFrom((org.apache.rocketmq.shaded.com.google.type.TimeZone) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(org.apache.rocketmq.shaded.com.google.type.TimeZone other) {
      if (other == org.apache.rocketmq.shaded.com.google.type.TimeZone.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
        org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      org.apache.rocketmq.shaded.com.google.type.TimeZone parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (org.apache.rocketmq.shaded.com.google.type.TimeZone) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * IANA Time Zone Database time zone, e.g. "America/New_York".
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IANA Time Zone Database time zone, e.g. "America/New_York".
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
            org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IANA Time Zone Database time zone, e.g. "America/New_York".
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      id_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IANA Time Zone Database time zone, e.g. "America/New_York".
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {

      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IANA Time Zone Database time zone, e.g. "America/New_York".
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(org.apache.rocketmq.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      id_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * Optional. IANA Time Zone Database version number, e.g. "2019a".
     * </pre>
     *
     * <code>string version = 2;</code>
     *
     * @return The version.
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. IANA Time Zone Database version number, e.g. "2019a".
     * </pre>
     *
     * <code>string version = 2;</code>
     *
     * @return The bytes for version.
     */
    public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
            org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. IANA Time Zone Database version number, e.g. "2019a".
     * </pre>
     *
     * <code>string version = 2;</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      version_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. IANA Time Zone Database version number, e.g. "2019a".
     * </pre>
     *
     * <code>string version = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {

      version_ = getDefaultInstance().getVersion();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. IANA Time Zone Database version number, e.g. "2019a".
     * </pre>
     *
     * <code>string version = 2;</code>
     *
     * @param value The bytes for version to set.
     * @return This builder for chaining.
     */
    public Builder setVersionBytes(org.apache.rocketmq.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      version_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.type.TimeZone)
  }

  // @@protoc_insertion_point(class_scope:google.type.TimeZone)
  private static final org.apache.rocketmq.shaded.com.google.type.TimeZone DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new org.apache.rocketmq.shaded.com.google.type.TimeZone();
  }

  public static org.apache.rocketmq.shaded.com.google.type.TimeZone getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final org.apache.rocketmq.shaded.com.google.protobuf.Parser<TimeZone> PARSER =
      new org.apache.rocketmq.shaded.com.google.protobuf.AbstractParser<TimeZone>() {
        @java.lang.Override
        public TimeZone parsePartialFrom(
            org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
            org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
          return new TimeZone(input, extensionRegistry);
        }
      };

  public static org.apache.rocketmq.shaded.com.google.protobuf.Parser<TimeZone> parser() {
    return PARSER;
  }

  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.protobuf.Parser<TimeZone> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.type.TimeZone getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
