/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package org.apache.rocketmq.shaded.io.opentelemetry.api.metrics;

/** Builder class for {@link LongHistogram}. */
public interface LongHistogramBuilder {
  /**
   * Sets the description for this instrument.
   *
   * <p>Description strings should follow the instrument description rules:
   * https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/api.md#instrument-description
   */
  LongHistogramBuilder setDescription(String description);

  /**
   * Sets the unit of measure for this instrument.
   *
   * <p>Unit strings should follow the instrument unit rules:
   * https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/api.md#instrument-unit
   */
  LongHistogramBuilder setUnit(String unit);

  /**
   * Builds and returns a {@code LongHistogram} with the desired options.
   *
   * @return a {@code LongHistogram} with the desired options.
   */
  LongHistogram build();
}
