/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package org.apache.rocketmq.shaded.io.opentelemetry.api.metrics;

import java.util.function.Consumer;

/**
 * A reference to an observable metric registered with {@link
 * DoubleCounterBuilder#buildWithCallback(Consumer)}.
 */
public interface ObservableDoubleCounter extends AutoCloseable {

  /**
   * Remove the callback registered via {@link DoubleCounterBuilder#buildWithCallback(Consumer)}.
   * After this is called, the callback won't be invoked on future collections. Subsequent calls to
   * {@link #close()} have no effect.
   *
   * <p>Note: other callbacks registered to the metric with the same identity are unaffected.
   */
  @Override
  default void close() {}
}
