/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data;

import javax.annotation.concurrent.Immutable;

/**
 * A sum metric point.
 *
 * <p>See:
 * https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/datamodel.md#sums
 */
@Immutable
public interface SumData<T extends PointData> extends Data<T> {
  /**
   * Returns "true" if the sum is monotonic.
   *
   * @return "true" if the sum is monotonic
   */
  boolean isMonotonic();

  /**
   * Returns the {@code AggregationTemporality} of this metric,
   *
   * <p>AggregationTemporality describes if the aggregator reports delta changes since last report
   * time, or cumulative changes since a fixed start time.
   *
   * @return the {@code AggregationTemporality} of this metric
   */
  AggregationTemporality getAggregationTemporality();
}
