/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_dnn;

import java.util.Arrays;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.StdVector;
import org.bytedeco.opencv.presets.opencv_dnn;

@Name(value={"std::vector<cv::dnn::MatShape>"})
@Properties(inherit={opencv_dnn.class})
public class MatShapeVector
extends Pointer {
    public MatShapeVector(Pointer p) {
        super(p);
    }

    public MatShapeVector(IntPointer value) {
        this(1L);
        this.put(0L, value);
    }

    public MatShapeVector(IntPointer ... array) {
        this(array.length);
        this.put(array);
    }

    public MatShapeVector() {
        this.allocate();
    }

    public MatShapeVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native MatShapeVector put(@ByRef MatShapeVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public IntPointer front() {
        return this.get(0L);
    }

    public IntPointer back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @StdVector
    public native IntPointer get(@Cast(value={"size_t"}) long var1);

    public native MatShapeVector put(@Cast(value={"size_t"}) long var1, IntPointer var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @StdVector IntPointer var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public IntPointer[] get() {
        IntPointer[] array = new IntPointer[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.get());
    }

    public IntPointer pop_back() {
        long size = this.size();
        IntPointer value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public MatShapeVector push_back(IntPointer value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public MatShapeVector put(IntPointer value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public MatShapeVector put(IntPointer ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @StdVector
        @Const
        public native IntPointer get();
    }
}

