/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.mojo.javacc.ForkedJvm;
import org.codehaus.mojo.javacc.ToolFacade;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.javacc.jjdoc.JJDocMain;

class JJDoc
extends ToolFacade {
    private File inputFile;
    private File outputFile;
    private String grammarEncoding;
    private String cssHref;
    private Boolean text;
    private Boolean bnf;
    private Boolean oneTable;

    JJDoc() {
    }

    public void setInputFile(File value) {
        if (value != null && !value.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + value);
        }
        this.inputFile = value;
    }

    public void setOutputFile(File value) {
        if (value != null && !value.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + value);
        }
        this.outputFile = value;
    }

    public void setGrammarEncoding(String value) {
        this.grammarEncoding = value;
    }

    public void setCssHref(String value) {
        this.cssHref = value;
    }

    public void setText(Boolean value) {
        this.text = value;
    }

    public void setBnf(Boolean value) {
        this.bnf = value;
    }

    public void setOneTable(Boolean value) {
        this.oneTable = value;
    }

    @Override
    protected int execute() throws Exception {
        File outputDirectory;
        String[] args = this.generateArguments();
        File file = outputDirectory = this.outputFile != null ? this.outputFile.getParentFile() : null;
        if (outputDirectory != null && !outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        ForkedJvm jvm = new ForkedJvm();
        jvm.setMainClass(JJDocMain.class);
        jvm.addArguments(args);
        jvm.setSystemOut(new MojoLogStreamConsumer(false));
        jvm.setSystemErr(new MojoLogStreamConsumer(true));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Forking: " + jvm));
        }
        return jvm.run();
    }

    private String[] generateArguments() {
        ArrayList<String> argsList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.grammarEncoding)) {
            argsList.add("-GRAMMAR_ENCODING=" + this.grammarEncoding);
        }
        if (this.text != null) {
            argsList.add("-TEXT=" + this.text);
        }
        if (this.bnf != null) {
            argsList.add("-BNF=" + this.bnf);
        }
        if (this.oneTable != null) {
            argsList.add("-ONE_TABLE=" + this.oneTable);
        }
        if (this.outputFile != null) {
            argsList.add("-OUTPUT_FILE=" + this.outputFile.getAbsolutePath());
        }
        if (StringUtils.isNotEmpty((String)this.cssHref)) {
            argsList.add("-CSS=" + this.cssHref);
        }
        if (this.inputFile != null) {
            argsList.add(this.inputFile.getAbsolutePath());
        }
        return argsList.toArray(new String[0]);
    }

    public String toString() {
        return Arrays.asList(this.generateArguments()).toString();
    }

    class MojoLogStreamConsumer
    implements StreamConsumer {
        private static final String ERROR_PREFIX = "Error: ";
        private static final String WARN_PREFIX = "Warning: ";
        private final boolean err;

        public MojoLogStreamConsumer(boolean error) {
            this.err = error;
        }

        public void consumeLine(String line) {
            if (line.startsWith(ERROR_PREFIX)) {
                JJDoc.this.getLog().error((CharSequence)line.substring(ERROR_PREFIX.length()));
            } else if (line.startsWith(WARN_PREFIX)) {
                JJDoc.this.getLog().warn((CharSequence)line.substring(WARN_PREFIX.length()));
            } else if (this.err) {
                JJDoc.this.getLog().error((CharSequence)line);
            } else {
                JJDoc.this.getLog().debug((CharSequence)line);
            }
        }
    }
}

