/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.PropertiesVersionsFileReader;

@Mojo(name="set-property", requiresProject=true, requiresDirectInvocation=true, threadSafe=true)
public class SetPropertyMojo
extends AbstractVersionsUpdaterMojo {
    @Parameter(property="property")
    private String property = null;
    @Parameter(property="newVersion")
    private String newVersion = null;
    @Parameter(property="autoLinkItems", defaultValue="true")
    private boolean autoLinkItems;
    @Parameter(property="propertiesVersionsFile")
    private String propertiesVersionsFile;

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        Property[] propertiesConfig = null;
        String properties = "";
        if (!StringUtils.isEmpty((CharSequence)this.propertiesVersionsFile)) {
            this.logWrongConfigWarning();
            this.getLog().debug((CharSequence)("Reading properties and versions to update from file: " + this.propertiesVersionsFile));
            PropertiesVersionsFileReader reader = new PropertiesVersionsFileReader(this.propertiesVersionsFile);
            try {
                reader.read();
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Unable to read property file  " + this.propertiesVersionsFile + ". re-run with -X option for more details."));
                this.getLog().debug((CharSequence)("Error while reading  property file " + this.propertiesVersionsFile), (Throwable)e);
                throw new MojoFailureException("Unable to read property file " + this.propertiesVersionsFile);
            }
            propertiesConfig = reader.getPropertiesConfig();
            properties = reader.getProperties();
        } else if (!StringUtils.isEmpty((CharSequence)this.property)) {
            this.getLog().debug((CharSequence)"Reading properties and versions to update from property and newVersion ");
            propertiesConfig = (Property[])Arrays.stream(StringUtils.split((String)this.property, (String)",")).map(prp -> {
                Property propertyConfig = new Property((String)prp);
                propertyConfig.setVersion(this.newVersion);
                return propertyConfig;
            }).toArray(Property[]::new);
            properties = this.property;
        } else {
            throw new MojoExecutionException("Please provide either 'property' or 'propertiesVersionsFile' parameter.");
        }
        this.update(pom, propertiesConfig, properties);
    }

    private void update(ModifiedPomXMLEventReader pom, Property[] propertiesConfig, String properties) throws MojoExecutionException, XMLStreamException {
        Map<Property, PropertyVersions> propertyVersions = this.getHelper().getVersionPropertiesMap(this.getProject(), propertiesConfig, properties, "", this.autoLinkItems);
        for (Map.Entry<Property, PropertyVersions> entry : propertyVersions.entrySet()) {
            Property currentProperty = entry.getKey();
            PropertyVersions version = entry.getValue();
            String newVersionGiven = currentProperty.getVersion();
            String currentVersion = this.getProject().getProperties().getProperty(currentProperty.getName());
            if (currentVersion == null) continue;
            PomHelper.setPropertyVersion(pom, version.getProfileId(), currentProperty.getName(), newVersionGiven);
        }
    }

    private void logWrongConfigWarning() {
        if (!StringUtils.isEmpty((CharSequence)this.property)) {
            this.getLog().warn((CharSequence)"-Dproperty provided but will be ignored as -DpropertiesVersionsFile is used");
        }
        if (!StringUtils.isEmpty((CharSequence)this.newVersion)) {
            this.getLog().warn((CharSequence)"-DnewVersion provided but will be ignored as -DpropertiesVersionsFile is used");
        }
    }
}

