/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="set-scm-tag", requiresDirectInvocation=true, aggregator=true, threadSafe=true)
public class SetScmTagMojo
extends AbstractVersionsUpdaterMojo {
    @Parameter(property="newTag")
    private String newTag;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (StringUtils.isBlank((CharSequence)this.newTag)) {
            throw new MojoFailureException("'newTag' cannot be empty");
        }
        super.execute();
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, ArtifactMetadataRetrievalException {
        try {
            Model model = PomHelper.getRawModel(pom);
            Scm scm = model.getScm();
            if (scm == null) {
                throw new MojoFailureException("No <scm> was present");
            }
            this.getLog().info((CharSequence)("Updating from tag " + scm.getTag() + " > " + this.newTag));
            boolean success = PomHelper.setProjectValue(pom, "/project/scm/tag", this.newTag);
            if (!success) {
                throw new MojoFailureException("Could not update the SCM tag");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

