/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.cyclonedx.Version;
import org.cyclonedx.maven.ModelConverter;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.Tool;
import org.cyclonedx.model.metadata.ToolInformation;
import org.cyclonedx.util.BomUtils;
import org.cyclonedx.util.LicenseResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultModelConverter
implements ModelConverter {
    private final Logger logger = LoggerFactory.getLogger(DefaultModelConverter.class);
    @Inject
    private MavenSession session;
    @Inject
    private RepositorySystem repositorySystem;
    @Inject
    private ProjectBuilder mavenProjectBuilder;

    @Override
    public String generatePackageUrl(Artifact artifact) {
        return this.generatePackageUrl(artifact, true);
    }

    @Override
    public String generateVersionlessPackageUrl(Artifact artifact) {
        return this.generatePackageUrl(artifact, false);
    }

    private String generatePackageUrl(Artifact artifact, boolean includeVersion) {
        TreeMap<String, String> qualifiers = null;
        if (artifact.getType() != null || artifact.getClassifier() != null) {
            qualifiers = new TreeMap<String, String>();
            if (artifact.getType() != null) {
                qualifiers.put("type", artifact.getType());
            }
            if (artifact.getClassifier() != null) {
                qualifiers.put("classifier", artifact.getClassifier());
            }
        }
        String version = includeVersion ? artifact.getBaseVersion() : null;
        return this.generatePackageUrl(artifact.getGroupId(), artifact.getArtifactId(), version, qualifiers, null);
    }

    @Override
    public String generatePackageUrl(org.eclipse.aether.artifact.Artifact artifact) {
        return this.generatePackageUrl(artifact, true, true);
    }

    @Override
    public String generateVersionlessPackageUrl(org.eclipse.aether.artifact.Artifact artifact) {
        return this.generatePackageUrl(artifact, false, true);
    }

    @Override
    public String generateClassifierlessPackageUrl(org.eclipse.aether.artifact.Artifact artifact) {
        return this.generatePackageUrl(artifact, true, false);
    }

    private boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    private String generatePackageUrl(org.eclipse.aether.artifact.Artifact artifact, boolean includeVersion, boolean includeClassifier) {
        TreeMap<String, String> qualifiers = null;
        String type = (String)artifact.getProperties().get("type");
        String classifier = artifact.getClassifier();
        if (!this.isEmpty(type) || includeClassifier && !this.isEmpty(classifier)) {
            qualifiers = new TreeMap<String, String>();
            if (!this.isEmpty(type)) {
                qualifiers.put("type", type);
            }
            if (includeClassifier && !this.isEmpty(classifier)) {
                qualifiers.put("classifier", classifier);
            }
        }
        String version = includeVersion ? artifact.getBaseVersion() : null;
        return this.generatePackageUrl(artifact.getGroupId(), artifact.getArtifactId(), version, qualifiers, null);
    }

    private String generatePackageUrl(String groupId, String artifactId, String version, TreeMap<String, String> qualifiers, String subpath) {
        try {
            return new PackageURL("maven", groupId, artifactId, version, qualifiers, subpath).canonicalize();
        }
        catch (MalformedPackageURLException e) {
            this.logger.warn("An unexpected issue occurred attempting to create a PackageURL for " + groupId + ":" + artifactId + ":" + version, (Throwable)e);
            return null;
        }
    }

    @Override
    public Component convertMavenDependency(Artifact artifact, Version schemaVersion, boolean includeLicenseText) {
        Component component = new Component();
        component.setGroup(artifact.getGroupId());
        component.setName(artifact.getArtifactId());
        component.setVersion(artifact.getBaseVersion());
        component.setType(Component.Type.LIBRARY);
        try {
            this.logger.debug("CycloneDX: Calculating Hashes");
            component.setHashes(BomUtils.calculateHashes((File)artifact.getFile(), (Version)schemaVersion));
        }
        catch (IOException e) {
            this.logger.error("Error encountered calculating hashes", (Throwable)e);
        }
        if (Version.VERSION_10 == schemaVersion) {
            component.setModified(Boolean.valueOf(this.isModified(artifact)));
        }
        component.setPurl(this.generatePackageUrl(artifact));
        if (Version.VERSION_10 != schemaVersion) {
            component.setBomRef(component.getPurl());
        }
        try {
            MavenProject project = this.getEffectiveMavenProject(artifact);
            if (project != null) {
                String projectType = this.getPluginConfiguration(project, "projectType");
                if (projectType != null) {
                    component.setType(this.resolveProjectType(projectType));
                }
                this.extractComponentMetadata(project, component, schemaVersion, includeLicenseText);
            }
        }
        catch (ProjectBuildingException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("Unable to create Maven project for " + artifact.getId() + " from repository.", (Throwable)e);
            }
            this.logger.warn("Unable to create Maven project for " + artifact.getId() + " from repository.");
        }
        return component;
    }

    public String getPluginConfiguration(MavenProject project, String property) {
        Plugin plugin = project.getPlugin("org.cyclonedx:cyclonedx-maven-plugin");
        Xpp3Dom configuration = plugin == null ? null : (Xpp3Dom)plugin.getConfiguration();
        Xpp3Dom value = configuration == null ? null : configuration.getChild(property);
        return value == null ? null : value.getValue();
    }

    private static void setExternalReferences(Component component, ExternalReference[] externalReferences) {
        if (externalReferences == null || externalReferences.length == 0) {
            return;
        }
        List externalReferences_ = Arrays.stream(externalReferences).collect(Collectors.toList());
        component.setExternalReferences(externalReferences_);
    }

    private boolean isModified(Artifact artifact) {
        return false;
    }

    private void extractComponentMetadata(MavenProject project, Component component, Version schemaVersion, boolean includeLicenseText) {
        if (component.getPublisher() == null && project.getOrganization() != null) {
            component.setPublisher(project.getOrganization().getName());
        }
        if (component.getDescription() == null) {
            component.setDescription(project.getDescription());
        }
        if ((component.getLicenseChoice() == null || component.getLicenseChoice().getLicenses() == null || component.getLicenseChoice().getLicenses().isEmpty()) && project.getLicenses() != null && project.getLicenses().stream().anyMatch(l -> !DefaultModelConverter.isLicenseBlank(l))) {
            component.setLicenseChoice(this.resolveMavenLicenses(project.getLicenses(), schemaVersion, includeLicenseText));
        }
        if (Version.VERSION_10 != schemaVersion) {
            this.addExternalReference(ExternalReference.Type.WEBSITE, project.getUrl(), component);
            if (project.getCiManagement() != null) {
                this.addExternalReference(ExternalReference.Type.BUILD_SYSTEM, project.getCiManagement().getUrl(), component);
            }
            if (project.getDistributionManagement() != null) {
                this.addExternalReference(ExternalReference.Type.DISTRIBUTION, project.getDistributionManagement().getDownloadUrl(), component);
                if (project.getDistributionManagement().getRepository() != null) {
                    ExternalReference.Type type = schemaVersion.getVersion() < 1.5 ? ExternalReference.Type.DISTRIBUTION : ExternalReference.Type.DISTRIBUTION_INTAKE;
                    this.addExternalReference(type, project.getDistributionManagement().getRepository().getUrl(), component);
                }
            }
            if (project.getIssueManagement() != null) {
                this.addExternalReference(ExternalReference.Type.ISSUE_TRACKER, project.getIssueManagement().getUrl(), component);
            }
            if (project.getMailingLists() != null && project.getMailingLists().size() > 0) {
                for (MailingList list : project.getMailingLists()) {
                    String url = list.getArchive();
                    if (url == null) {
                        url = list.getSubscribe();
                    }
                    this.addExternalReference(ExternalReference.Type.MAILING_LIST, url, component);
                }
            }
            if (project.getScm() != null) {
                this.addExternalReference(ExternalReference.Type.VCS, project.getScm().getUrl(), component);
            }
        }
    }

    private MavenProject getEffectiveMavenProject(Artifact artifact) throws ProjectBuildingException {
        Artifact pomArtifact = this.repositorySystem.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        ProjectBuildingResult build = this.mavenProjectBuilder.build(pomArtifact, this.session.getProjectBuildingRequest().setValidationLevel(0).setProcessPlugins(false));
        return build.getProject();
    }

    private void addExternalReference(ExternalReference.Type referenceType, String url, Component component) {
        if (DefaultModelConverter.isBlank(url) || this.doesComponentHaveExternalReference(component, referenceType)) {
            return;
        }
        try {
            URI uri = new URI(url.trim());
            ExternalReference ref = new ExternalReference();
            ref.setType(referenceType);
            ref.setUrl(uri.toString());
            component.addExternalReference(ref);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private boolean doesComponentHaveExternalReference(Component component, ExternalReference.Type referenceType) {
        if (component.getExternalReferences() != null && !component.getExternalReferences().isEmpty()) {
            for (ExternalReference ref : component.getExternalReferences()) {
                if (referenceType != ref.getType()) continue;
                return true;
            }
        }
        return false;
    }

    private LicenseChoice resolveMavenLicenses(List<License> projectLicenses, Version schemaVersion, boolean includeLicenseText) {
        LicenseChoice licenseChoice = new LicenseChoice();
        for (License artifactLicense : projectLicenses) {
            boolean resolved = false;
            if (artifactLicense.getName() != null) {
                LicenseChoice resolvedByName = LicenseResolver.resolve((String)artifactLicense.getName(), (boolean)includeLicenseText);
                resolved = this.resolveLicenseInfo(licenseChoice, resolvedByName, schemaVersion);
            }
            if (artifactLicense.getUrl() != null && !resolved) {
                LicenseChoice resolvedByUrl = LicenseResolver.resolve((String)artifactLicense.getUrl(), (boolean)includeLicenseText);
                resolved = this.resolveLicenseInfo(licenseChoice, resolvedByUrl, schemaVersion);
            }
            if (artifactLicense.getName() == null || resolved) continue;
            org.cyclonedx.model.License license = new org.cyclonedx.model.License();
            license.setName(artifactLicense.getName().trim());
            if (StringUtils.isNotBlank((CharSequence)artifactLicense.getUrl())) {
                try {
                    URI uri = new URI(artifactLicense.getUrl().trim());
                    license.setUrl(uri.toString());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            licenseChoice.addLicense(license);
        }
        return licenseChoice;
    }

    private boolean resolveLicenseInfo(LicenseChoice licenseChoice, LicenseChoice licenseChoiceToResolve, Version schemaVersion) {
        if (licenseChoiceToResolve != null) {
            if (licenseChoiceToResolve.getLicenses() != null && !licenseChoiceToResolve.getLicenses().isEmpty()) {
                licenseChoice.addLicense((org.cyclonedx.model.License)licenseChoiceToResolve.getLicenses().get(0));
                return true;
            }
            if (licenseChoiceToResolve.getExpression() != null && Version.VERSION_10 != schemaVersion) {
                licenseChoice.setExpression(licenseChoiceToResolve.getExpression());
                return true;
            }
        }
        return false;
    }

    @Override
    public Metadata convertMavenProject(MavenProject project, String projectType, Version schemaVersion, boolean includeLicenseText, ExternalReference[] externalReferences) {
        Metadata metadata = new Metadata();
        Properties properties = this.readPluginProperties();
        List hashes = null;
        DefaultArtifact self = new DefaultArtifact(properties.getProperty("groupId"), properties.getProperty("artifactId"), properties.getProperty("version"), "compile", "jar", null, (ArtifactHandler)new DefaultArtifactHandler());
        Artifact resolved = this.session.getLocalRepository().find((Artifact)self);
        if (resolved != null) {
            try {
                resolved.setFile(new File(resolved.getFile() + ".jar"));
                hashes = BomUtils.calculateHashes((File)resolved.getFile(), (Version)schemaVersion);
            }
            catch (IOException e) {
                this.logger.warn("Unable to calculate hashes of self", (Throwable)e);
            }
        }
        if (schemaVersion.compareTo((Enum)Version.VERSION_15) < 0) {
            Tool tool = new Tool();
            tool.setVendor(properties.getProperty("vendor"));
            tool.setName(properties.getProperty("name"));
            tool.setVersion(properties.getProperty("version"));
            tool.setHashes(hashes);
            metadata.addTool(tool);
        } else {
            ToolInformation toolInfo = new ToolInformation();
            Component toolComponent = new Component();
            toolComponent.setType(Component.Type.LIBRARY);
            toolComponent.setGroup(properties.getProperty("groupId"));
            toolComponent.setName(properties.getProperty("artifactId"));
            toolComponent.setVersion(properties.getProperty("version"));
            toolComponent.setDescription(properties.getProperty("name"));
            toolComponent.setAuthor(properties.getProperty("vendor"));
            toolComponent.setHashes(hashes);
            toolInfo.setComponents(Collections.singletonList(toolComponent));
            metadata.setToolChoice(toolInfo);
        }
        Component component = new Component();
        component.setGroup(project.getGroupId());
        component.setName(project.getArtifactId());
        component.setVersion(project.getVersion());
        component.setType(this.resolveProjectType(projectType));
        component.setPurl(this.generatePackageUrl(project.getArtifact()));
        component.setBomRef(component.getPurl());
        DefaultModelConverter.setExternalReferences(component, externalReferences);
        this.extractComponentMetadata(project, component, schemaVersion, includeLicenseText);
        metadata.setComponent(component);
        return metadata;
    }

    private Properties readPluginProperties() {
        Properties props = new Properties();
        try {
            props.load(this.getClass().getClassLoader().getResourceAsStream("plugin.properties"));
        }
        catch (IOException | NullPointerException e) {
            this.logger.warn("Unable to load plugin.properties", (Throwable)e);
        }
        return props;
    }

    private Component.Type resolveProjectType(String projectType) {
        for (Component.Type type : Component.Type.values()) {
            if (!type.getTypeName().equalsIgnoreCase(projectType)) continue;
            return type;
        }
        this.logger.warn("Invalid project type. Defaulting to 'library'");
        this.logger.warn("Valid types are:");
        for (Component.Type type : Component.Type.values()) {
            this.logger.warn("  " + type.getTypeName());
        }
        return Component.Type.LIBRARY;
    }

    private static boolean isBlank(String s) {
        return s == null || s.isEmpty() || s.trim().isEmpty();
    }

    private static boolean isLicenseBlank(License license) {
        return DefaultModelConverter.isBlank(license.getName()) && DefaultModelConverter.isBlank(license.getUrl());
    }
}

