/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version.git;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jetty.toolchain.version.git.GitCommit;

public class GitFilter {
    private List<Pattern> filenameExcludes = new ArrayList<Pattern>();

    public void addFilenameExclude(String excludePathRegex) {
        this.filenameExcludes.add(Pattern.compile(excludePathRegex));
    }

    public List<GitCommit> filter(List<GitCommit> commits) {
        ArrayList<GitCommit> results = new ArrayList<GitCommit>();
        for (GitCommit commit : commits) {
            ArrayList<String> filteredFilenames = new ArrayList<String>();
            for (String filename : commit.getFilenames()) {
                boolean isExcluded = false;
                for (Pattern exclude : this.filenameExcludes) {
                    if (!exclude.matcher(filename).matches()) continue;
                    isExcluded = true;
                    break;
                }
                if (isExcluded) continue;
                filteredFilenames.add(filename);
            }
            if (filteredFilenames.size() <= 0) continue;
            commit.setFilenames(filteredFilenames);
            results.add(commit);
        }
        return results;
    }
}

