/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Properties;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PlatformMBeanServerLookup;

public class GlobalJmxStatisticsConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<GlobalJmxStatisticsConfiguration> {
    private Properties properties = new Properties();
    private String jmxDomain = "org.infinispan";
    private Boolean allowDuplicateDomains = false;
    private String cacheManagerName = "DefaultCacheManager";
    private MBeanServerLookup mBeanServerLookupInstance = (MBeanServerLookup)Util.getInstance(PlatformMBeanServerLookup.class);
    private boolean enabled = false;

    GlobalJmxStatisticsConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
    }

    public GlobalJmxStatisticsConfigurationBuilder withProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder jmxDomain(String jmxDomain) {
        this.jmxDomain = jmxDomain;
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder allowDuplicateDomains(Boolean allowDuplicateDomains) {
        this.allowDuplicateDomains = allowDuplicateDomains;
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder cacheManagerName(String cacheManagerName) {
        this.cacheManagerName = cacheManagerName;
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder mBeanServerLookup(MBeanServerLookup mBeanServerLookupInstance) {
        this.mBeanServerLookupInstance = mBeanServerLookupInstance;
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void validate() {
    }

    public GlobalJmxStatisticsConfiguration create() {
        return new GlobalJmxStatisticsConfiguration(this.enabled, this.jmxDomain, this.mBeanServerLookupInstance, this.allowDuplicateDomains, this.cacheManagerName, TypedProperties.toTypedProperties((Properties)this.properties));
    }

    public GlobalJmxStatisticsConfigurationBuilder read(GlobalJmxStatisticsConfiguration template) {
        this.allowDuplicateDomains = template.allowDuplicateDomains();
        this.cacheManagerName = template.cacheManagerName();
        this.enabled = template.enabled();
        this.jmxDomain = template.domain();
        this.mBeanServerLookupInstance = template.mbeanServerLookup();
        this.properties = template.properties();
        return this;
    }

    public String toString() {
        return "GlobalJmxStatisticsConfigurationBuilder{allowDuplicateDomains=" + this.allowDuplicateDomains + ", properties=" + this.properties + ", jmxDomain='" + this.jmxDomain + '\'' + ", cacheManagerName='" + this.cacheManagerName + '\'' + ", mBeanServerLookupInstance=" + this.mBeanServerLookupInstance + ", enabled=" + this.enabled + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalJmxStatisticsConfigurationBuilder that = (GlobalJmxStatisticsConfigurationBuilder)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        if (this.allowDuplicateDomains != null ? !this.allowDuplicateDomains.equals(that.allowDuplicateDomains) : that.allowDuplicateDomains != null) {
            return false;
        }
        if (this.cacheManagerName != null ? !this.cacheManagerName.equals(that.cacheManagerName) : that.cacheManagerName != null) {
            return false;
        }
        if (this.jmxDomain != null ? !this.jmxDomain.equals(that.jmxDomain) : that.jmxDomain != null) {
            return false;
        }
        if (this.mBeanServerLookupInstance != null ? !this.mBeanServerLookupInstance.equals(that.mBeanServerLookupInstance) : that.mBeanServerLookupInstance != null) {
            return false;
        }
        return !(this.properties != null ? !this.properties.equals(that.properties) : that.properties != null);
    }

    public int hashCode() {
        int result = this.properties != null ? this.properties.hashCode() : 0;
        result = 31 * result + (this.jmxDomain != null ? this.jmxDomain.hashCode() : 0);
        result = 31 * result + (this.allowDuplicateDomains != null ? this.allowDuplicateDomains.hashCode() : 0);
        result = 31 * result + (this.cacheManagerName != null ? this.cacheManagerName.hashCode() : 0);
        result = 31 * result + (this.mBeanServerLookupInstance != null ? this.mBeanServerLookupInstance.hashCode() : 0);
        result = 31 * result + (this.enabled ? 1 : 0);
        return result;
    }
}

