/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.persistence.file.SingleFileStore;

@BuiltBy(value=SingleFileStoreConfigurationBuilder.class)
@ConfigurationFor(value=SingleFileStore.class)
public class SingleFileStoreConfiguration
extends AbstractStoreConfiguration {
    public static final AttributeDefinition<String> LOCATION = AttributeDefinition.builder((String)"location", (Object)"Infinispan-SingleFileStore").immutable().xmlName("path").build();
    public static final AttributeDefinition<Integer> MAX_ENTRIES = AttributeDefinition.builder((String)"maxEntries", (Object)-1).immutable().build();
    public static final AttributeDefinition<Float> FRAGMENTATION_FACTOR = AttributeDefinition.builder((String)"fragmentationFactor", (Object)Float.valueOf(0.75f)).immutable().build();
    private final Attribute<String> location;
    private final Attribute<Integer> maxEntries;
    private final Attribute<Float> fragmentationFactor;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SingleFileStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{LOCATION, MAX_ENTRIES, FRAGMENTATION_FACTOR});
    }

    public SingleFileStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore) {
        super(attributes, async, singletonStore);
        this.location = attributes.attribute(LOCATION);
        this.maxEntries = attributes.attribute(MAX_ENTRIES);
        this.fragmentationFactor = attributes.attribute(FRAGMENTATION_FACTOR);
    }

    public String location() {
        return (String)this.location.get();
    }

    public int maxEntries() {
        return (Integer)this.maxEntries.get();
    }

    public float fragmentationFactor() {
        return ((Float)this.fragmentationFactor.get()).floatValue();
    }

    @Override
    public AttributeSet attributes() {
        return this.attributes;
    }

    @Override
    public String toString() {
        return "SingleFileStoreConfiguration [attributes=" + this.attributes + "]";
    }
}

