/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.plugin.cli.Commands;
import org.jboss.as.plugin.common.AbstractServerMojo;
import org.jboss.as.plugin.common.DeploymentExecutionException;
import org.jboss.as.plugin.common.DeploymentFailureException;
import org.jboss.as.plugin.deployment.Deployment;
import org.jboss.as.plugin.deployment.MatchPatternStrategy;
import org.jboss.as.plugin.deployment.domain.Domain;
import org.jboss.as.plugin.deployment.domain.DomainDeployment;
import org.jboss.as.plugin.deployment.standalone.StandaloneDeployment;

abstract class AbstractDeployment
extends AbstractServerMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter
    private Domain domain;
    @Parameter
    protected String name;
    @Parameter(alias="before-deployment")
    private Commands beforeDeployment;
    @Parameter(alias="after-deployment")
    private Commands afterDeployment;

    AbstractDeployment() {
    }

    protected abstract File file();

    @Override
    public abstract String goal();

    public abstract Deployment.Type getType();

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().debug((CharSequence)String.format("Skipping deployment of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        this.doExecute();
    }

    protected final Deployment.Status executeDeployment(ModelControllerClient client, Deployment deployment) throws DeploymentExecutionException, DeploymentFailureException, IOException {
        if (this.beforeDeployment != null) {
            this.beforeDeployment.execute(client);
        }
        this.getLog().debug((CharSequence)"Executing deployment");
        Deployment.Status status = deployment.execute();
        if (this.afterDeployment != null) {
            this.afterDeployment.execute(client);
        }
        return status;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            void var4_9;
            this.validate();
            ModelControllerClient client = this.getClient();
            String matchPattern = this.getMatchPattern();
            MatchPatternStrategy matchPatternStrategy = this.getMatchPatternStrategy();
            if (this.isDomainServer()) {
                DomainDeployment domainDeployment = DomainDeployment.create((DomainClient)client, this.domain, this.file(), this.name, this.getType(), matchPattern, matchPatternStrategy);
            } else {
                StandaloneDeployment standaloneDeployment = StandaloneDeployment.create(client, this.file(), this.name, this.getType(), matchPattern, matchPatternStrategy);
            }
            switch (this.executeDeployment(client, (Deployment)var4_9)) {
                case REQUIRES_RESTART: {
                    this.getLog().info((CharSequence)"Server requires a restart");
                    return;
                }
            }
            return;
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Could not execute goal %s on %s. Reason: %s", this.goal(), this.file(), e.getMessage()), e);
        }
        finally {
            this.close();
        }
    }

    protected String getMatchPattern() {
        return null;
    }

    protected MatchPatternStrategy getMatchPatternStrategy() {
        return null;
    }

    protected void validate() throws DeploymentFailureException {
        if (this.isDomainServer()) {
            if (this.domain == null || this.domain.getServerGroups().isEmpty()) {
                throw new DeploymentFailureException("Server is running in domain mode, but no server groups have been defined.");
            }
        } else if (this.domain != null && !this.domain.getServerGroups().isEmpty()) {
            throw new DeploymentFailureException("Server is running in standalone mode, but server groups have been defined.");
        }
    }
}

