/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader;

import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvCallbackHandler;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.RecordType;

public abstract class AbstractBaseCsvCallbackHandler<T>
extends CsvCallbackHandler<T> {
    private long startingLineNumber;
    private RecordType recordType = RecordType.DATA;
    private int fieldCount;

    protected AbstractBaseCsvCallbackHandler() {
    }

    protected long getStartingLineNumber() {
        return this.startingLineNumber;
    }

    @Override
    protected RecordType getRecordType() {
        return this.recordType;
    }

    @Override
    protected int getFieldCount() {
        return this.fieldCount;
    }

    @Override
    protected final void beginRecord(long startingLineNumber) {
        this.startingLineNumber = startingLineNumber;
        this.fieldCount = 0;
        this.recordType = RecordType.DATA;
        this.handleBegin(startingLineNumber);
    }

    protected void handleBegin(long startingLineNumber) {
    }

    @Override
    protected final void addField(char[] buf, int offset, int len, boolean quoted) {
        this.handleField(this.fieldCount++, buf, offset, len, quoted);
    }

    protected void handleField(int fieldIdx, char[] buf, int offset, int len, boolean quoted) {
    }

    @Override
    protected final void setComment(char[] buf, int offset, int len) {
        this.recordType = RecordType.COMMENT;
        this.handleComment(buf, offset, len);
        this.fieldCount = 1;
    }

    protected void handleComment(char[] buf, int offset, int len) {
    }

    @Override
    protected final void setEmpty() {
        this.recordType = RecordType.EMPTY;
        this.handleEmpty();
        this.fieldCount = 1;
    }

    protected void handleEmpty() {
    }
}

