/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.LiquibaseRollback;
import org.liquibase.maven.property.PropertyElement;

public class LiquibaseFutureRollbackSQL
extends LiquibaseRollback {
    @PropertyElement
    protected File outputFile;
    private Writer outputWriter;

    @Override
    protected Liquibase createLiquibase(Database db) throws MojoExecutionException {
        Liquibase liquibase = super.createLiquibase(db);
        try {
            if (!this.outputFile.exists()) {
                this.outputFile.getParentFile().mkdirs();
                if (!this.outputFile.createNewFile()) {
                    throw new MojoExecutionException("Cannot create the output file; " + this.outputFile.getAbsolutePath());
                }
            }
            this.outputWriter = this.getOutputWriter(this.outputFile);
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to create SQL output writer", (Exception)e);
        }
        this.getLog().info((CharSequence)("Output File: " + this.outputFile.getAbsolutePath()));
        return liquibase;
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "outputFile: " + this.outputFile));
    }

    @Override
    protected void cleanup(Database db) {
        super.cleanup(db);
        if (this.outputWriter != null) {
            try {
                this.outputWriter.close();
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        liquibase.futureRollbackSQL(new Contexts(this.contexts), new LabelExpression(this.getLabelFilter()), this.outputWriter);
    }

    @Override
    protected void checkRequiredRollbackParameters() throws MojoFailureException {
    }
}

