/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.forked;

import java.io.File;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.ops4j.exec.DefaultJavaRunner;
import org.ops4j.exec.ExecutionException;
import org.ops4j.net.FreePort;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.swissbox.framework.RemoteFramework;
import org.ops4j.pax.swissbox.framework.RemoteFrameworkImpl;
import org.ops4j.pax.swissbox.tracker.ServiceLookup;
import org.osgi.framework.launch.FrameworkFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForkedFrameworkFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ForkedFrameworkFactory.class);
    private static final long TIMEOUT = 60000L;
    private FrameworkFactory frameworkFactory;
    private Registry registry;
    private int port;
    private DefaultJavaRunner javaRunner;

    public ForkedFrameworkFactory(FrameworkFactory frameworkFactory) {
        this.frameworkFactory = frameworkFactory;
    }

    public FrameworkFactory getFrameworkFactory() {
        return this.frameworkFactory;
    }

    public void setFrameworkFactory(FrameworkFactory frameworkFactory) {
        this.frameworkFactory = frameworkFactory;
    }

    public RemoteFramework fork(List<String> vmArgs, Map<String, String> systemProperties, Map<String, Object> frameworkProperties, List<String> beforeFrameworkClasspath, List<String> afterFrameworkClasspath) {
        FreePort freePort = new FreePort(21000, 21099);
        this.port = freePort.getPort();
        LOG.debug("using RMI registry at port {}", (Object)this.port);
        String rmiName = "ExamRemoteFramework-" + UUID.randomUUID().toString();
        try {
            String address = InetAddress.getLoopbackAddress().getHostAddress();
            System.setProperty("java.rmi.server.hostname", address);
            this.registry = LocateRegistry.createRegistry(this.port);
            HashMap<String, String> systemPropsNew = new HashMap<String, String>(systemProperties);
            systemPropsNew.put("java.rmi.server.hostname", address);
            systemPropsNew.put("pax.swissbox.framework.rmi.port", Integer.toString(this.port));
            systemPropsNew.put("pax.swissbox.framework.rmi.name", rmiName);
            String[] vmOptions = this.buildSystemProperties(vmArgs, systemPropsNew);
            String[] args = this.buildFrameworkProperties(frameworkProperties);
            this.javaRunner = new DefaultJavaRunner(false);
            this.javaRunner.exec(vmOptions, this.buildClasspath(beforeFrameworkClasspath, afterFrameworkClasspath), RemoteFrameworkImpl.class.getName(), args, this.getJavaHome(), null);
            return this.findRemoteFramework(this.port, rmiName);
        }
        catch (URISyntaxException | RemoteException | ExecutionException exc) {
            throw new TestContainerException(exc);
        }
    }

    public RemoteFramework fork(List<String> vmArgs, Map<String, String> systemProperties, Map<String, Object> frameworkProperties) {
        return this.fork(vmArgs, systemProperties, frameworkProperties, null, null);
    }

    private String[] buildSystemProperties(List<String> vmArgs, Map<String, String> systemProperties) {
        String[] vmOptions = new String[vmArgs.size() + systemProperties.size()];
        int i = 0;
        for (String string : vmArgs) {
            vmOptions[i++] = string;
        }
        for (Map.Entry entry : systemProperties.entrySet()) {
            vmOptions[i++] = String.format("-D%s=%s", entry.getKey(), entry.getValue());
        }
        return vmOptions;
    }

    private String[] buildFrameworkProperties(Map<String, Object> frameworkProperties) {
        String[] args = new String[frameworkProperties.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : frameworkProperties.entrySet()) {
            args[i++] = String.format("-F%s=%s", entry.getKey(), entry.getValue().toString());
        }
        return args;
    }

    private String getJavaHome() {
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome == null) {
            javaHome = System.getProperty("java.home");
        }
        return javaHome;
    }

    private String[] buildClasspath(List<String> beforeFrameworkClasspath, List<String> afterFrameworkClasspath) throws URISyntaxException {
        String frameworkPath = ForkedFrameworkFactory.toPath(this.frameworkFactory.getClass());
        String launcherPath = ForkedFrameworkFactory.toPath(RemoteFrameworkImpl.class);
        String serviceLookupPath = ForkedFrameworkFactory.toPath(ServiceLookup.class);
        int entries = (beforeFrameworkClasspath != null ? beforeFrameworkClasspath.size() : 0) + 3 + (afterFrameworkClasspath != null ? afterFrameworkClasspath.size() : 0);
        String[] classpath = new String[entries];
        int i = 0;
        if (beforeFrameworkClasspath != null) {
            for (String beforeFrameworkLibrary : beforeFrameworkClasspath) {
                if (!new File(beforeFrameworkLibrary).exists()) {
                    throw new TestContainerException("Invalid boot classpath library: " + beforeFrameworkLibrary);
                }
                classpath[i++] = beforeFrameworkLibrary;
            }
        }
        classpath[i++] = frameworkPath;
        classpath[i++] = launcherPath;
        classpath[i++] = serviceLookupPath;
        if (afterFrameworkClasspath != null) {
            for (String afterFrameworkLibrary : afterFrameworkClasspath) {
                if (!new File(afterFrameworkLibrary).exists()) {
                    throw new TestContainerException("Invalid boot classpath library: " + afterFrameworkLibrary);
                }
                classpath[i++] = afterFrameworkLibrary;
            }
        }
        return classpath;
    }

    static String toPath(Class<?> klass) throws URISyntaxException {
        return klass.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
    }

    private RemoteFramework findRemoteFramework(int _port, String rmiName) {
        RemoteFramework framework = null;
        Exception reason = null;
        long startedTrying = System.currentTimeMillis();
        do {
            try {
                String address = InetAddress.getLoopbackAddress().getHostAddress();
                Registry reg = LocateRegistry.getRegistry(address, _port);
                framework = (RemoteFramework)reg.lookup(rmiName);
            }
            catch (RemoteException e) {
                reason = e;
            }
            catch (NotBoundException e) {
                reason = e;
            }
        } while (framework == null && System.currentTimeMillis() < startedTrying + 60000L);
        if (framework == null) {
            throw new TestContainerException("cannot find remote framework in RMI registry", (Throwable)reason);
        }
        return framework;
    }

    public void join() {
        try {
            UnicastRemoteObject.unexportObject(this.registry, true);
            this.javaRunner.shutdown();
        }
        catch (NoSuchObjectException exc) {
            throw new TestContainerException((Throwable)exc);
        }
    }
}

