/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.forked;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.ops4j.io.StreamUtils;
import org.ops4j.pax.exam.ConfigurationManager;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.forked.ForkedFrameworkFactory;
import org.ops4j.pax.exam.forked.provision.PlatformImpl;
import org.ops4j.pax.exam.options.BootClasspathLibraryOption;
import org.ops4j.pax.exam.options.BootDelegationOption;
import org.ops4j.pax.exam.options.FrameworkPropertyOption;
import org.ops4j.pax.exam.options.FrameworkStartLevelOption;
import org.ops4j.pax.exam.options.PropagateSystemPropertyOption;
import org.ops4j.pax.exam.options.ProvisionOption;
import org.ops4j.pax.exam.options.SystemPackageOption;
import org.ops4j.pax.exam.options.SystemPropertyOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.options.ValueOption;
import org.ops4j.pax.exam.options.extra.RepositoryOption;
import org.ops4j.pax.exam.options.extra.VMOption;
import org.ops4j.pax.swissbox.framework.RemoteFramework;
import org.ops4j.pax.swissbox.framework.RemoteServiceReference;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.FrameworkFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForkedTestContainer
implements TestContainer {
    private static final Logger LOG = LoggerFactory.getLogger(ForkedTestContainer.class);
    private ExamSystem system;
    private final ForkedFrameworkFactory frameworkFactory;
    private RemoteFramework remoteFramework;
    private final PlatformImpl platform;
    private final String name;
    private Long probeId;

    public ForkedTestContainer(ExamSystem system, FrameworkFactory frameworkFactory) {
        this.system = system;
        this.frameworkFactory = new ForkedFrameworkFactory(frameworkFactory);
        this.platform = new PlatformImpl();
        this.name = "Forked:" + frameworkFactory.getClass().getSimpleName();
    }

    public void call(TestAddress address) {
        String filterExpression = "(&(objectClass=org.ops4j.pax.exam.ProbeInvoker)(Probe-Signature=" + address.root().identifier() + "))";
        try {
            RemoteServiceReference[] references = this.remoteFramework.getServiceReferences(filterExpression, this.system.getTimeout().getValue(), TimeUnit.MILLISECONDS);
            this.remoteFramework.invokeMethodOnService(references[0], "call", new Object[]{address.arguments()});
        }
        catch (Exception exc) {
            throw new TestContainerException((Throwable)exc);
        }
    }

    public long install(String location, InputStream stream) {
        try {
            return this.remoteFramework.installBundle(location);
        }
        catch (RemoteException | BundleException exc) {
            throw new TestContainerException(exc);
        }
    }

    public long install(InputStream stream) {
        try {
            long bundleId = this.remoteFramework.installBundle("local", this.pack(stream));
            this.remoteFramework.startBundle(bundleId);
            return bundleId;
        }
        catch (RemoteException | BundleException exc) {
            throw new TestContainerException(exc);
        }
    }

    public TestContainer start() {
        try {
            this.system = this.system.fork(new Option[]{CoreOptions.systemProperty((String)"java.protocol.handler.pkgs").value("org.ops4j.pax.url")});
            List<String> vmArgs = this.createVmArguments();
            Map<String, String> systemProperties = this.createSystemProperties();
            Map<String, Object> frameworkProperties = this.createFrameworkProperties();
            ArrayList<String> beforeFrameworkClasspath = new ArrayList<String>();
            ArrayList<String> afterFrameworkClasspath = new ArrayList<String>();
            BootClasspathLibraryOption[] bootClasspathLibraryOptions = (BootClasspathLibraryOption[])this.system.getOptions(BootClasspathLibraryOption.class);
            if (bootClasspathLibraryOptions != null && bootClasspathLibraryOptions.length > 0) {
                for (BootClasspathLibraryOption bootClasspathLibraryOption : bootClasspathLibraryOptions) {
                    UrlReference libraryUrl = bootClasspathLibraryOption.getLibraryUrl();
                    String library = this.localize(libraryUrl.getURL());
                    if (bootClasspathLibraryOption.isAfterFramework()) {
                        afterFrameworkClasspath.add(library);
                        continue;
                    }
                    beforeFrameworkClasspath.add(library);
                }
            }
            this.remoteFramework = this.frameworkFactory.fork(vmArgs, systemProperties, frameworkProperties, beforeFrameworkClasspath, afterFrameworkClasspath);
            this.remoteFramework.init();
            this.installAndStartBundles();
        }
        catch (IOException | BundleException exc) {
            throw new TestContainerException(exc);
        }
        return this;
    }

    public TestContainer stop() {
        try {
            this.remoteFramework.stop();
            this.system.clear();
        }
        catch (RemoteException | BundleException exc) {
            throw new TestContainerException(exc);
        }
        this.frameworkFactory.join();
        this.system.clear();
        return this;
    }

    private byte[] pack(InputStream stream) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            StreamUtils.copyStream((InputStream)stream, (OutputStream)out, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    private Map<String, Object> createFrameworkProperties() throws IOException {
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("org.osgi.framework.storage", this.system.getTempFolder().getAbsolutePath());
        SystemPackageOption[] systemPackageOptions = (SystemPackageOption[])this.system.getOptions(SystemPackageOption.class);
        if (systemPackageOptions.length > 0) {
            p.put("org.osgi.framework.system.packages.extra", this.buildString((ValueOption<?>[])systemPackageOptions));
        }
        p.put("org.osgi.framework.bootdelegation", this.buildString((ValueOption[])this.system.getOptions(BootDelegationOption.class)));
        for (FrameworkPropertyOption frameworkPropertyOption : (FrameworkPropertyOption[])this.system.getOptions(FrameworkPropertyOption.class)) {
            p.put(frameworkPropertyOption.getKey(), frameworkPropertyOption.getValue());
        }
        for (FrameworkPropertyOption frameworkPropertyOption : (SystemPropertyOption[])this.system.getOptions(SystemPropertyOption.class)) {
            System.setProperty(frameworkPropertyOption.getKey(), frameworkPropertyOption.getValue());
        }
        return p;
    }

    private List<String> createVmArguments() {
        VMOption[] options = (VMOption[])this.system.getOptions(VMOption.class);
        ArrayList<String> args = new ArrayList<String>();
        for (VMOption option : options) {
            args.add(option.getOption());
        }
        return args;
    }

    private Map<String, String> createSystemProperties() {
        HashMap<String, String> p = new HashMap<String, String>();
        for (PropagateSystemPropertyOption propagateSystemPropertyOption : (PropagateSystemPropertyOption[])this.system.getOptions(PropagateSystemPropertyOption.class)) {
            String key = propagateSystemPropertyOption.getKey();
            String value = System.getProperty(key);
            if (value == null) continue;
            p.put(key, value);
        }
        for (PropagateSystemPropertyOption propagateSystemPropertyOption : (SystemPropertyOption[])this.system.getOptions(SystemPropertyOption.class)) {
            p.put(propagateSystemPropertyOption.getKey(), propagateSystemPropertyOption.getValue());
        }
        RepositoryOption[] repositories = (RepositoryOption[])this.system.getOptions(RepositoryOption.class);
        if (repositories.length != 0) {
            System.setProperty("org.ops4j.pax.url.mvn.repositories", this.buildString((ValueOption<?>[])repositories));
        }
        return p;
    }

    private String buildString(ValueOption<?>[] options) {
        return this.buildString(new String[0], options, new String[0]);
    }

    private String buildString(String[] prepend, ValueOption<?>[] options, String[] append) {
        StringBuilder builder = new StringBuilder();
        for (String string : prepend) {
            builder.append(string);
            builder.append(",");
        }
        for (String string : options) {
            builder.append(string.getValue());
            builder.append(",");
        }
        for (String string : append) {
            builder.append(string);
            builder.append(",");
        }
        if (builder.length() > 0) {
            return builder.substring(0, builder.length() - 1);
        }
        return "";
    }

    private void installAndStartBundles() throws BundleException, RemoteException {
        File workDir = new File(this.system.getTempFolder(), "pax-exam-downloads");
        workDir.mkdirs();
        ArrayList<Long> bundleIds = new ArrayList<Long>();
        ProvisionOption[] options = (ProvisionOption[])this.system.getOptions(ProvisionOption.class);
        HashMap<String, Long> remoteMappings = new HashMap<String, Long>();
        HashMap<Long, String> bundlesById = new HashMap<Long, String>();
        for (ProvisionOption bundle : options) {
            String localUrl = this.downloadBundle(workDir, bundle.getURL());
            long bundleId = this.remoteFramework.installBundle(localUrl);
            remoteMappings.put(bundle.getURL(), bundleId);
            bundlesById.put(bundleId, bundle.getURL());
        }
        this.remoteFramework.start();
        for (ProvisionOption bundle : options) {
            int startLevel = this.getStartLevel(bundle);
            Long bundleId = (Long)remoteMappings.get(bundle.getURL());
            this.remoteFramework.setBundleStartLevel(bundleId.longValue(), startLevel);
            if (bundle.shouldStart()) {
                bundleIds.add(bundleId);
                this.remoteFramework.startBundle(bundleId.longValue());
                LOG.debug("+ Install (start@{}) {}", (Object)startLevel, (Object)bundle);
                continue;
            }
            LOG.debug("+ Install (no start) {}", (Object)bundle);
        }
        this.setFrameworkStartLevel();
        this.verifyThatBundlesAreResolved(bundleIds, bundlesById);
    }

    private void setFrameworkStartLevel() throws RemoteException {
        FrameworkStartLevelOption startLevelOption = (FrameworkStartLevelOption)this.system.getSingleOption(FrameworkStartLevelOption.class);
        int startLevel = startLevelOption == null ? 5 : startLevelOption.getStartLevel();
        LOG.debug("Jump to startlevel [{}]", (Object)startLevel);
        long timeout = this.system.getTimeout().getValue();
        boolean startLevelReached = this.remoteFramework.setFrameworkStartLevel(startLevel, timeout);
        if (!startLevelReached) {
            String msg = String.format("start level %d has not been reached within %d ms", startLevel, timeout);
            throw new TestContainerException(msg);
        }
    }

    private void verifyThatBundlesAreResolved(List<Long> bundleIds, Map<Long, String> bundlesById) throws RemoteException {
        boolean hasUnresolvedBundles = false;
        for (long bundleId : bundleIds) {
            try {
                if (this.remoteFramework.getBundleState(bundleId) != 2) continue;
                LOG.error("Bundle [id:{}, url:{}] is not resolved", (Object)bundleId, (Object)bundlesById.get(bundleId));
                hasUnresolvedBundles = true;
            }
            catch (BundleException exc) {
                throw new TestContainerException((Throwable)exc);
            }
        }
        ConfigurationManager cm = new ConfigurationManager();
        boolean failOnUnresolved = Boolean.parseBoolean(cm.getProperty("pax.exam.osgi.unresolved.fail", "false"));
        if (hasUnresolvedBundles && failOnUnresolved) {
            throw new TestContainerException("There are unresolved bundles. See previous ERROR log messages for details.");
        }
    }

    private String downloadBundle(File workDir, String url) {
        try {
            URL realUrl = new URL(url);
            if (realUrl.getProtocol().equals("reference")) {
                return url;
            }
            File localBundle = this.platform.download(workDir, realUrl, url, false, true, true, false);
            return localBundle.toURI().toURL().toString();
        }
        catch (MalformedURLException exc) {
            throw new TestContainerException((Throwable)exc);
        }
    }

    private String localize(String url) {
        try {
            URL realUrl = new URL(url);
            if (realUrl.getProtocol().equals("reference")) {
                return new URL(realUrl.getPath()).getPath();
            }
            if (realUrl.getProtocol().equals("file")) {
                return realUrl.getPath();
            }
            File artifact = this.platform.download(this.system.getTempFolder(), realUrl, url, false, false, false, false);
            return artifact.getCanonicalPath();
        }
        catch (MalformedURLException exc) {
            throw new TestContainerException((Throwable)exc);
        }
        catch (IOException exc) {
            throw new TestContainerException((Throwable)exc);
        }
    }

    private int getStartLevel(ProvisionOption<?> bundle) {
        Integer start = bundle.getStartLevel();
        if (start == null) {
            start = 3;
        }
        return start;
    }

    public String toString() {
        return this.name;
    }

    public long installProbe(InputStream stream) {
        this.probeId = this.install(stream);
        return this.probeId;
    }

    public void uninstallProbe() {
        try {
            this.remoteFramework.uninstallBundle(this.probeId.longValue());
        }
        catch (RemoteException | BundleException exc) {
            throw new TestContainerException(exc);
        }
    }
}

