/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.forked.provision;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.forked.provision.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File download(File workDir, URL url, String displayName, Boolean overwrite, boolean checkAttributes, boolean failOnValidation, boolean downloadFeeback) {
        String cachingName;
        boolean forceOverwrite;
        LOGGER.debug("Downloading [" + url + "]");
        File downloadedBundlesFile = new File(workDir, "downloaded_bundles.properties");
        Properties fileNamesForUrls = this.loadProperties(downloadedBundlesFile);
        String downloadedFileName = fileNamesForUrls.getProperty(url.toExternalForm());
        String hashFileName = "" + url.toExternalForm().hashCode();
        if (downloadedFileName == null) {
            downloadedFileName = hashFileName + ".jar";
        }
        File destination = new File(workDir, downloadedFileName);
        boolean bl = forceOverwrite = overwrite != false || !destination.exists();
        if (!forceOverwrite) {
            try {
                cachingName = this.determineCachingName(destination, hashFileName);
                if (!destination.getName().equals(cachingName)) {
                    throw new TestContainerException("File " + destination + " should have name " + cachingName);
                }
            }
            catch (TestContainerException ignore) {
                forceOverwrite = true;
            }
        }
        if (forceOverwrite) {
            try {
                LOGGER.debug("Creating new file at destination: " + destination.getAbsolutePath());
                destination.getParentFile().mkdirs();
                destination.createNewFile();
                try (FileOutputStream os = null;){
                    os = new FileOutputStream(destination);
                    FileChannel fileChannel = os.getChannel();
                    StreamUtils.ProgressBar progressBar = null;
                    if (LOGGER.isInfoEnabled()) {
                        progressBar = downloadFeeback ? new StreamUtils.FineGrainedProgressBar(displayName) : new StreamUtils.CoarseGrainedProgressBar(displayName);
                    }
                    if (url.getPath().endsWith("/") && "file".equals(url.getProtocol())) {
                        StreamUtils.streamCopy(new URL("assembly:" + url.toExternalForm()), fileChannel, progressBar);
                    } else {
                        StreamUtils.streamCopy(url, fileChannel, progressBar);
                    }
                    fileChannel.close();
                    LOGGER.debug("Successfully downloaded to [" + destination + "]");
                }
            }
            catch (IOException e) {
                throw new TestContainerException("[" + url + "] could not be downloaded", (Throwable)e);
            }
        }
        if (checkAttributes) {
            try {
                this.validateBundle(url, destination);
            }
            catch (TestContainerException e) {
                if (failOnValidation) {
                    throw e;
                }
                return null;
            }
        }
        cachingName = this.determineCachingName(destination, hashFileName);
        File newDestination = new File(destination.getParentFile(), cachingName);
        if (!cachingName.equals(destination.getName())) {
            if (newDestination.exists() && !newDestination.delete()) {
                throw new TestContainerException("Cannot delete " + newDestination);
            }
            if (!destination.renameTo(newDestination)) {
                throw new TestContainerException("Cannot rename " + destination + " to " + newDestination);
            }
            fileNamesForUrls.setProperty(url.toExternalForm(), cachingName);
            this.saveProperties(fileNamesForUrls, downloadedBundlesFile);
        }
        return newDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(File file) {
        Properties properties = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            Properties properties3 = properties;
            return properties3;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void saveProperties(Properties properties, File file) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            properties.store(os, "");
        }
        catch (IOException e) {
            throw new TestContainerException("Cannot store properties " + file, (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateBundle(URL url, File file) {
        String bundleName;
        String bundleSymbolicName;
        block18: {
            bundleSymbolicName = null;
            bundleName = null;
            if (url.getPath().endsWith("/")) {
                try {
                    URL manifestURL = new URL(url, "META-INF/MANIFEST.MF");
                    try (InputStream stream = manifestURL.openStream();){
                        Manifest manifest = new Manifest(stream);
                        bundleSymbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                        bundleName = manifest.getMainAttributes().getValue("Bundle-Name");
                        break block18;
                    }
                }
                catch (IOException e) {
                    throw new TestContainerException("[" + url + "] is not a valid exploded bundle", (Throwable)e);
                }
            }
            JarFile jar = null;
            try {
                jar = new JarFile(file, false);
                Manifest manifest = jar.getManifest();
                if (manifest == null) {
                    throw new TestContainerException("[" + url + "] is not a valid bundle (manifest is missing)");
                }
                bundleSymbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                bundleName = manifest.getMainAttributes().getValue("Bundle-Name");
            }
            catch (IOException e) {
                throw new TestContainerException("[" + url + "] is not a valid bundle (reading jar failed)", (Throwable)e);
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (bundleSymbolicName == null && bundleName == null) {
            throw new TestContainerException("[" + url + "] is not a valid bundle (bundleSymbolicName and bundleName are null)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String determineCachingName(File file, String defaultBundleSymbolicName) {
        String bundleSymbolicName = null;
        String bundleVersion = null;
        JarFile jar = null;
        try {
            jar = new JarFile(file, false);
            Manifest manifest = jar.getManifest();
            if (manifest != null) {
                bundleSymbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                bundleVersion = manifest.getMainAttributes().getValue("Bundle-Version");
            }
        }
        catch (IOException manifest) {
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException manifest) {}
            }
        }
        if (bundleSymbolicName == null) {
            bundleSymbolicName = defaultBundleSymbolicName;
        } else {
            int semicolonPos = bundleSymbolicName.indexOf(";");
            if (semicolonPos > 0) {
                bundleSymbolicName = bundleSymbolicName.substring(0, semicolonPos);
            }
        }
        if (bundleVersion == null) {
            bundleVersion = "0.0.0";
        }
        return bundleSymbolicName + "_" + bundleVersion + ".jar";
    }
}

