/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.forked.provision;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.forked.provision.Info;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamUtils.class);

    private StreamUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamCopy(InputStream in, FileChannel out, ProgressBar progressBar) throws IOException {
        NullArgumentException.validateNotNull((Object)in, (String)"Input stream");
        NullArgumentException.validateNotNull((Object)out, (String)"Output stream");
        long start = System.currentTimeMillis();
        long bytes = 0L;
        ProgressBar feedbackBar = progressBar;
        if (feedbackBar == null) {
            feedbackBar = new NullProgressBar();
        }
        try {
            ReadableByteChannel inChannel = Channels.newChannel(in);
            bytes = out.transferFrom(inChannel, 0L, Integer.MAX_VALUE);
            inChannel.close();
        }
        finally {
            feedbackBar.increment(bytes, bytes / Math.max(System.currentTimeMillis() - start, 1L));
            feedbackBar.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamCopy(URL url, FileChannel out, ProgressBar progressBar) throws IOException {
        NullArgumentException.validateNotNull((Object)url, (String)"URL");
        try (InputStream is = null;){
            is = url.openStream();
            StreamUtils.streamCopy(is, out, progressBar);
        }
    }

    public static class CoarseGrainedProgressBar
    implements ProgressBar {
        private final String downloadTargetName;
        private long bytes;
        private long kbps;

        public CoarseGrainedProgressBar(String downloadTargetName) {
            this.downloadTargetName = downloadTargetName;
            LOGGER.debug(downloadTargetName + " : downloading...");
        }

        @Override
        public void increment(long _bytes, long _kbps) {
            this.bytes = _bytes;
            this.kbps = _kbps;
        }

        @Override
        public void stop() {
            LOGGER.debug(this.downloadTargetName + " : " + this.bytes + " bytes @ [ " + this.kbps + "kBps ]");
        }
    }

    public static class FineGrainedProgressBar
    implements ProgressBar {
        int counter;
        private final String downloadTargetName;

        public FineGrainedProgressBar(String downloadTargetName) {
            this.downloadTargetName = downloadTargetName;
            Info.print(downloadTargetName + " : connecting...\r");
        }

        @Override
        public void increment(long bytes, long kbps) {
            Info.print(this.downloadTargetName + " : " + bytes + " bytes @ [ " + kbps + "kBps ]\r");
            ++this.counter;
        }

        @Override
        public void stop() {
            Info.println();
        }
    }

    public static class NullProgressBar
    implements ProgressBar {
        @Override
        public void increment(long bytes, long kbps) {
        }

        @Override
        public void stop() {
        }
    }

    public static interface ProgressBar {
        public void increment(long var1, long var3);

        public void stop();
    }
}

