/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.rbc.internal;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.Callable;
import org.ops4j.pax.exam.rbc.internal.RemoteBundleContext;
import org.ops4j.pax.exam.rbc.internal.RemoteBundleContextImpl;
import org.ops4j.pax.swissbox.core.ContextClassLoaderUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private static final int MAXRETRYCOUNT = 14;
    private static final String MSG_RETRY = "RBC bind stuff failed before. Will retry again perhaps.";
    private static final int PORT_RBC_FROM = 22412;
    private static final int PORT_RBC_TO = 22512;
    private Registry m_registry;
    private volatile RemoteBundleContext m_remoteBundleContext;
    private Thread m_registerRBCThread;

    public synchronized void start(final BundleContext bundleContext) throws Exception {
        String host = this.getHost();
        String name = this.getName();
        Integer port = this.getPort();
        if (host == null || port == null || name == null) {
            LOG.info("Name, port or host is null. So this RBC remains inactive.");
            return;
        }
        this.m_registerRBCThread = new Thread(new Runnable(){

            public void run() {
                int retries = 0;
                boolean valid = false;
                do {
                    ++retries;
                    valid = Activator.this.register(bundleContext);
                    if (valid) continue;
                    try {
                        LOG.debug(Activator.MSG_RETRY);
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } while (!Thread.currentThread().isInterrupted() && !valid && retries < 14);
            }
        });
        this.m_registerRBCThread.start();
    }

    private boolean register(final BundleContext bundleContext) {
        try {
            ContextClassLoaderUtils.doWithClassLoader(null, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    int port = Activator.this.getPort();
                    String host = Activator.this.getHost();
                    String name = Activator.this.getName();
                    LOG.debug("Trying to find registry on [host=" + host + " port=" + port + "]");
                    Activator.this.m_registry = LocateRegistry.getRegistry(Activator.this.getHost(), Activator.this.getPort());
                    Activator.this.bindRBC(Activator.this.m_registry, name, bundleContext);
                    LOG.debug("Container with name " + name + " has added its RBC");
                    return null;
                }
            });
            return true;
        }
        catch (Exception e) {
            LOG.warn("Registration of RBC failed: ", (Throwable)e);
            return false;
        }
    }

    private void bindRBC(Registry registry, String name, BundleContext bundleContext) throws RemoteException, BundleException {
        LOG.debug("Now Binding " + RemoteBundleContext.class.getSimpleName() + " as name=" + name + " to RMI registry");
        this.m_remoteBundleContext = new RemoteBundleContextImpl(bundleContext.getBundle(0L).getBundleContext());
        Remote remoteStub = UnicastRemoteObject.exportObject((Remote)this.m_remoteBundleContext, 0);
        registry.rebind(this.getName(), remoteStub);
    }

    public synchronized void stop(BundleContext bundleContext) throws Exception {
        if (this.m_registerRBCThread != null) {
            this.m_registerRBCThread.interrupt();
            String name = this.getName();
            this.m_registry.unbind(name);
            UnicastRemoteObject.unexportObject(this.m_remoteBundleContext, true);
            this.m_registry = null;
            this.m_remoteBundleContext = null;
            LOG.debug("Container with name " + name + " has removed its RBC");
        }
    }

    private int getPort() throws BundleException {
        try {
            return Integer.parseInt(System.getProperty("org.ops4j.pax.exam.rbc.rmi.port"));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private String getHost() throws BundleException {
        return System.getProperty("org.ops4j.pax.exam.rbc.rmi.host");
    }

    private String getName() throws BundleException {
        return System.getProperty("org.ops4j.pax.exam.rbc.rmi.name");
    }
}

