/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.intern;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestProbeProvider;
import org.ops4j.store.Handle;
import org.ops4j.store.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTestProbeProvider
implements TestProbeProvider {
    private TestAddress[] m_tests;
    private Handle m_probe;
    private Store<InputStream> m_store;
    private String m_formattedInfo = "";

    public DefaultTestProbeProvider(TestAddress[] tests, Store<InputStream> store, Handle probe) {
        this.m_tests = tests;
        this.m_store = store;
        this.m_probe = probe;
        this.m_formattedInfo = this.constuctInfo();
    }

    public TestAddress[] getTests() {
        return this.m_tests;
    }

    public InputStream getStream() throws IOException {
        return (InputStream)this.m_store.load(this.m_probe);
    }

    public String toString() {
        return this.m_formattedInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String constuctInfo() {
        ZipInputStream in = null;
        String info = "";
        try {
            info = info + "[Probe ID: " + this.m_probe.getIdentification() + "]\n";
            info = info + "[Probe Location: " + this.m_store.getLocation(this.m_probe).toASCIIString() + "]\n";
            in = new JarInputStream((InputStream)this.m_store.load(this.m_probe));
            Manifest man = ((JarInputStream)in).getManifest();
            Attributes mainAttributes = man.getMainAttributes();
            info = info + "[Tests: \n";
            for (TestAddress t : this.m_tests) {
                info = info + "    SIG=" + t + "\n";
            }
            info = info + "]\n";
            info = info + "[Headers: \n";
            for (Object key : mainAttributes.keySet()) {
                info = info + "    " + key + "=" + mainAttributes.get(key) + "\n";
            }
            info = info + "]\n";
            info = "\n--\n" + info + "--\n";
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return info;
    }
}

