/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.testforge;

import org.ops4j.pax.exam.TestContainerException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;

public class SingleClassProvider {
    private static final long LOADED_FROM_BOOTCLASSLOADER = -2L;
    private static final long LOADED_FROM_OTHER_CLASSLOADER = -3L;
    private static final long CLAZZ_NOT_FOUND = -4L;
    private static final long UNCHECKED = -1L;

    public void probe(BundleContext ctx, String clazzName, Boolean optionalSkipSystemBundle) throws Exception {
        long commonSource = -1L;
        String sourceName = "";
        for (Bundle b : ctx.getBundles()) {
            if (optionalSkipSystemBundle != null && optionalSkipSystemBundle.booleanValue() && b.getBundleId() == 0L) continue;
            long loaded = this.findSafe(b, clazzName);
            if (commonSource == -1L && loaded != -4L) {
                commonSource = loaded;
                sourceName = b.getSymbolicName();
                continue;
            }
            if (loaded == -4L || commonSource == loaded) continue;
            throw new TestContainerException("Test failed because class " + clazzName + " has been loaded from at least two different sources: " + this.map(commonSource, sourceName) + " vs. " + this.map(loaded, b.getSymbolicName()) + ".");
        }
    }

    private String map(long loaded, String name) {
        if (loaded == -2L) {
            return "[" + name + " loaded from " + "Bootclassloader]";
        }
        if (loaded == -3L) {
            return "[" + name + " loaded from " + "Other Classloader]";
        }
        return "[" + name + " loaded from " + " Bundle " + loaded + "]";
    }

    private long findSafe(Bundle bundle, String className) {
        try {
            Class clazz = bundle.loadClass(className);
            if (clazz.getClassLoader() == null) {
                return -2L;
            }
            if (clazz.getClassLoader() instanceof BundleReference) {
                Bundle p = ((BundleReference)clazz.getClassLoader()).getBundle();
                return p.getBundleId();
            }
            return -3L;
        }
        catch (ClassNotFoundException ex) {
            return -4L;
        }
    }
}

