/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam;

import java.io.InputStream;
import java.util.Properties;

public class Info {
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String m_paxExamVersion;
    private static final String m_paxUrlVersion;
    private static final String m_paxRunnerVersion;
    private static final String m_ops4jBaseVersion;
    private static final String m_paxSwissboxVersion;
    private static boolean m_paxExamSnapshotVersion;
    private static boolean m_paxUrlSnapshotVersion;
    private static boolean m_ops4jBaseSnapshotVersion;
    private static boolean m_paxSwissboxSnapshotVersion;

    private Info() {
    }

    public static String getPaxExamVersion() {
        return m_paxExamVersion;
    }

    public static String getPaxUrlVersion() {
        return m_paxUrlVersion;
    }

    public static String getPaxRunnerVersion() {
        return m_paxRunnerVersion;
    }

    public static String getOps4jBaseVersion() {
        return m_ops4jBaseVersion;
    }

    public static String getPaxSwissboxVersion() {
        return m_paxSwissboxVersion;
    }

    public static boolean isPaxExamSnapshotVersion() {
        return m_paxExamSnapshotVersion;
    }

    public static boolean isPaxUrlSnapshotVersion() {
        return m_paxUrlSnapshotVersion;
    }

    public static boolean isOps4jBaseSnapshotVersion() {
        return m_ops4jBaseSnapshotVersion;
    }

    public static boolean isPaxSwissboxSnapshotVersion() {
        return m_paxSwissboxSnapshotVersion;
    }

    public static void showLogo() {
        System.out.println("__________                 ___________");
        System.out.println("\\______   \\_____  ___  ___ \\_   _____/__  ________    _____");
        System.out.println(" |     ___/\\__  \\ \\  \\/  /  |    __)_\\  \\/  /\\__  \\  /     \\");
        System.out.println(" |    |     / __ \\_>    <   |        \\>    <  / __ \\|  Y Y  \\");
        System.out.println(" |____|    (____  /__/\\_ \\ /_______  /__/\\_ \\(____  /__|_|  /");
        System.out.println("                \\/      \\/         \\/      \\/     \\/      \\/");
        System.out.println();
        String logo = "Pax Exam " + Info.getPaxExamVersion() + " from OPS4J - http://www.ops4j.org";
        System.out.println(logo);
        System.out.println("---------------------------------------------------------------------------------------------------------".substring(0, logo.length()));
        System.out.println();
    }

    static {
        String paxExamVersion = "";
        String paxUrlVersion = "";
        String paxRunnerVersion = "";
        String ops4jBaseVersion = "";
        String paxSwissboxVersion = "";
        try {
            InputStream is = Info.class.getClassLoader().getResourceAsStream("META-INF/pax-exam-version.properties");
            if (is != null) {
                Properties properties = new Properties();
                properties.load(is);
                paxExamVersion = properties.getProperty("pax.exam.version", "").trim();
                paxUrlVersion = properties.getProperty("pax.url.version", "").trim();
                paxRunnerVersion = properties.getProperty("pax.runner.version", "").trim();
                ops4jBaseVersion = properties.getProperty("ops4j.base.version", "").trim();
                paxSwissboxVersion = properties.getProperty("pax.swissbox.version").trim();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        m_paxExamVersion = paxExamVersion;
        m_paxUrlVersion = paxUrlVersion;
        m_paxRunnerVersion = paxRunnerVersion;
        m_ops4jBaseVersion = ops4jBaseVersion;
        m_paxSwissboxVersion = paxSwissboxVersion;
        m_paxExamSnapshotVersion = paxExamVersion.endsWith(SNAPSHOT);
        m_paxUrlSnapshotVersion = paxUrlVersion.endsWith(SNAPSHOT);
        m_ops4jBaseSnapshotVersion = ops4jBaseVersion.endsWith(SNAPSHOT);
        m_paxSwissboxSnapshotVersion = paxSwissboxVersion.endsWith(SNAPSHOT);
    }
}

