/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import org.ops4j.pax.exam.options.MavenUrlReference;

public class MavenUtils {
    private MavenUtils() {
    }

    public static String getArtifactVersion(String groupId, String artifactId) {
        Properties dependencies = new Properties();
        try {
            dependencies.load(new FileInputStream(MavenUtils.getFileFromClasspath("META-INF/maven/dependencies.properties")));
            String version = dependencies.getProperty(groupId + "/" + artifactId + "/version");
            if (version == null) {
                throw new RuntimeException("Could not resolve version. Do you have a dependency for " + groupId + "/" + artifactId + " in your maven project?");
            }
            return version;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not resolve version for groupId:" + groupId + " artifactId:" + artifactId + " by reading the dependency information generated by maven.", e);
        }
    }

    public static MavenUrlReference.VersionResolver asInProject() {
        return new MavenUrlReference.VersionResolver(){

            public String getVersion(String groupId, String artifactId) {
                return MavenUtils.getArtifactVersion(groupId, artifactId);
            }
        };
    }

    private static File getFileFromClasspath(String filePath) throws FileNotFoundException {
        try {
            URL fileURL = MavenUtils.class.getClassLoader().getResource(filePath);
            if (fileURL == null) {
                throw new FileNotFoundException("File [" + filePath + "] could not be found in classpath");
            }
            return new File(fileURL.toURI());
        }
        catch (URISyntaxException e) {
            throw new FileNotFoundException("File [" + filePath + "] could not be found: " + e.getMessage());
        }
    }
}

