/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.options;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.MavenUtils;
import org.ops4j.pax.exam.options.MavenUrlReference;

public class MavenArtifactUrlReference
implements MavenUrlReference {
    private String m_groupId;
    private String m_artifactId;
    private String m_type;
    private String m_version;
    private String m_classifier;

    public MavenArtifactUrlReference groupId(String groupId) {
        NullArgumentException.validateNotEmpty((String)groupId, (boolean)true, (String)"Group");
        this.m_groupId = groupId;
        return this;
    }

    public MavenArtifactUrlReference artifactId(String artifactId) {
        NullArgumentException.validateNotEmpty((String)artifactId, (boolean)true, (String)"Artifact");
        this.m_artifactId = artifactId;
        return this;
    }

    public MavenArtifactUrlReference type(String type) {
        NullArgumentException.validateNotEmpty((String)type, (boolean)true, (String)"Type");
        this.m_type = type;
        return this;
    }

    public MavenUrlReference classifier(String classifier) {
        NullArgumentException.validateNotEmpty((String)classifier, (boolean)true, (String)"Classifier");
        this.m_classifier = classifier;
        return this;
    }

    public MavenArtifactUrlReference version(String version) {
        NullArgumentException.validateNotEmpty((String)version, (boolean)true, (String)"Version");
        this.m_version = version;
        return this;
    }

    public MavenArtifactUrlReference version(MavenUrlReference.VersionResolver resolver) {
        NullArgumentException.validateNotNull((Object)resolver, (String)"Version resolver");
        return this.version(resolver.getVersion(this.m_groupId, this.m_artifactId));
    }

    public MavenArtifactUrlReference versionAsInProject() {
        return this.version(MavenUtils.asInProject());
    }

    public Boolean isSnapshot() {
        return this.m_version == null ? null : Boolean.valueOf(this.m_version.endsWith("SNAPSHOT"));
    }

    public String getURL() {
        NullArgumentException.validateNotEmpty((String)this.m_groupId, (boolean)true, (String)"Group");
        NullArgumentException.validateNotEmpty((String)this.m_artifactId, (boolean)true, (String)"Artifact");
        StringBuilder url = new StringBuilder();
        url.append("mvn:").append(this.m_groupId).append("/").append(this.m_artifactId);
        if (this.m_version != null || this.m_type != null || this.m_classifier != null) {
            url.append("/");
        }
        if (this.m_version != null) {
            url.append(this.m_version);
        }
        if (this.m_type != null || this.m_classifier != null) {
            url.append("/");
        }
        if (this.m_type != null) {
            url.append(this.m_type);
        }
        if (this.m_classifier != null) {
            url.append("/").append(this.m_classifier);
        }
        return url.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{groupId='").append(this.m_groupId).append('\'');
        sb.append(", artifactId='").append(this.m_artifactId).append('\'');
        sb.append(", version='").append(this.m_version).append('\'');
        sb.append(", type='").append(this.m_type).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

