/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.moduleloader;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.framework.Logger;
import org.apache.felix.moduleloader.IContentLoader;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IModuleDefinition;
import org.apache.felix.moduleloader.IModuleFactory;
import org.apache.felix.moduleloader.ModuleEvent;
import org.apache.felix.moduleloader.ModuleImpl;
import org.apache.felix.moduleloader.ModuleListener;

public class ModuleFactoryImpl
implements IModuleFactory {
    private Logger m_logger = null;
    private Map m_moduleMap = new HashMap();
    private ModuleListener[] m_listeners = null;
    private static final ModuleListener[] m_noListeners = new ModuleListener[0];

    public ModuleFactoryImpl(Logger logger) {
        this.m_logger = logger;
        this.m_listeners = m_noListeners;
    }

    public synchronized IModule[] getModules() {
        return this.m_moduleMap.values().toArray(new IModule[this.m_moduleMap.size()]);
    }

    public synchronized IModule getModule(String id) {
        return (IModule)this.m_moduleMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModule createModule(String id, IModuleDefinition md) {
        ModuleImpl module = null;
        ModuleFactoryImpl moduleFactoryImpl = this;
        synchronized (moduleFactoryImpl) {
            if (this.m_moduleMap.get(id) != null) {
                throw new IllegalArgumentException("Module ID must be unique.");
            }
            module = new ModuleImpl(this.m_logger, id, md);
            this.m_moduleMap.put(id, module);
        }
        this.fireModuleAdded(module);
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModule(IModule module) {
        ModuleFactoryImpl moduleFactoryImpl = this;
        synchronized (moduleFactoryImpl) {
            if (this.m_moduleMap.get(module.getId()) == null) {
                return;
            }
            this.m_moduleMap.remove(module.getId());
            ((ModuleImpl)module).getContentLoader().close();
        }
        this.fireModuleRemoved(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContentLoader(IModule module, IContentLoader contentLoader) {
        ModuleFactoryImpl moduleFactoryImpl = this;
        synchronized (moduleFactoryImpl) {
            ((ModuleImpl)module).setContentLoader(contentLoader);
            contentLoader.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecurityContext(IModule module, Object securityContext) {
        ModuleFactoryImpl moduleFactoryImpl = this;
        synchronized (moduleFactoryImpl) {
            ((ModuleImpl)module).setSecurityContext(securityContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModuleListener(ModuleListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        ModuleListener[] moduleListenerArray = m_noListeners;
        synchronized (m_noListeners) {
            if (this.m_listeners == m_noListeners) {
                this.m_listeners = new ModuleListener[]{l};
            } else {
                ModuleListener[] newList = new ModuleListener[this.m_listeners.length + 1];
                System.arraycopy(this.m_listeners, 0, newList, 0, this.m_listeners.length);
                newList[this.m_listeners.length] = l;
                this.m_listeners = newList;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModuleListener(ModuleListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        ModuleListener[] moduleListenerArray = m_noListeners;
        synchronized (m_noListeners) {
            int idx = -1;
            for (int i = 0; i < this.m_listeners.length; ++i) {
                if (!this.m_listeners[i].equals(l)) continue;
                idx = i;
                break;
            }
            if (idx >= 0) {
                if (this.m_listeners.length == 1) {
                    this.m_listeners = m_noListeners;
                } else {
                    ModuleListener[] newList = new ModuleListener[this.m_listeners.length - 1];
                    System.arraycopy(this.m_listeners, 0, newList, 0, idx);
                    if (idx < newList.length) {
                        System.arraycopy(this.m_listeners, idx + 1, newList, idx, newList.length - idx);
                    }
                    this.m_listeners = newList;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void fireModuleAdded(IModule module) {
        ModuleEvent event = null;
        ModuleListener[] listeners = this.m_listeners;
        for (int i = 0; i < listeners.length; ++i) {
            if (event == null) {
                event = new ModuleEvent(this, module);
            }
            listeners[i].moduleAdded(event);
        }
    }

    protected void fireModuleRemoved(IModule module) {
        ModuleEvent event = null;
        ModuleListener[] listeners = this.m_listeners;
        for (int i = 0; i < listeners.length; ++i) {
            if (event == null) {
                event = new ModuleEvent(this, module);
            }
            listeners[i].moduleRemoved(event);
        }
    }
}

