/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform.builder;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.runner.platform.PlatformBuilder;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractPlatformBuilderActivator
implements BundleActivator {
    private static final Log LOGGER = LogFactory.getLog(AbstractPlatformBuilderActivator.class);
    private BundleContext m_bundleContext;
    private ServiceRegistration[] m_platformBuilderServiceReg;

    public void start(BundleContext bundleContext) throws Exception {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        this.m_bundleContext = bundleContext;
        this.registerPlatformBuilders(this.createPlatformBuilders(this.m_bundleContext));
        LOGGER.debug((Object)("Platform builder [" + this + "] started"));
    }

    public void stop(BundleContext bundleContext) throws Exception {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        if (this.m_platformBuilderServiceReg != null) {
            for (ServiceRegistration registration : this.m_platformBuilderServiceReg) {
                if (registration == null) continue;
                registration.unregister();
            }
            this.m_platformBuilderServiceReg = null;
        }
        this.m_bundleContext = null;
        LOGGER.debug((Object)("Platform builder [" + this + "] stopped"));
    }

    private void registerPlatformBuilders(PlatformBuilder[] platformBuilders) {
        this.m_platformBuilderServiceReg = new ServiceRegistration[platformBuilders.length];
        int i = 0;
        for (PlatformBuilder platformBuilder : platformBuilders) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("provider", platformBuilder.getProviderName());
            ((Dictionary)props).put("version", platformBuilder.getProviderVersion());
            this.m_platformBuilderServiceReg[i++] = this.m_bundleContext.registerService(PlatformBuilder.class.getName(), (Object)platformBuilder, props);
        }
    }

    protected abstract PlatformBuilder[] createPlatformBuilders(BundleContext var1);
}

