/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import org.eclipse.aether.internal.impl.SimpleLocalRepositoryManager;
import org.eclipse.aether.internal.impl.TrackingFileManager;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;

public class PaxLocalRepositoryManager
extends SimpleLocalRepositoryManager {
    public static final String PROPERTY_UPDATE_RELEASES = "paxUrlAether.updateReleases";
    private final UpdatePolicyAnalyzer updatePolicyAnalyzer;
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final String trackingFilename;
    private final TrackingFileManager trackingFileManager;

    public PaxLocalRepositoryManager(File basedir, UpdatePolicyAnalyzer updatePolicyAnalyzer, RemoteRepositoryManager remoteRepositoryManager) {
        super(basedir);
        this.updatePolicyAnalyzer = updatePolicyAnalyzer;
        this.remoteRepositoryManager = remoteRepositoryManager;
        this.trackingFilename = "_pax-url-aether-remote.repositories";
        this.trackingFileManager = new TrackingFileManager();
    }

    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        String localKey;
        File trackingFile;
        Properties props;
        LocalArtifactResult result = super.find(session, request);
        if (result.isAvailable() && !request.getArtifact().isSnapshot() && ((Boolean)session.getConfigProperties().get(PROPERTY_UPDATE_RELEASES)).booleanValue() && (props = this.trackingFileManager.read(trackingFile = this.getTrackingFile(result.getFile()))) != null && props.get(localKey = result.getFile().getName() + ">") == null) {
            for (RemoteRepository repo : request.getRepositories()) {
                RepositoryPolicy policy;
                long lastUpdated;
                String remoteKey = result.getFile().getName() + ">" + repo.getId();
                if (props.get(remoteKey) == null || !this.updatePolicyAnalyzer.isUpdatedRequired(session, lastUpdated = result.getFile().lastModified(), (policy = this.remoteRepositoryManager.getPolicy(session, repo, true, false)).getUpdatePolicy())) continue;
                result.setAvailable(false);
                result.setFile(null);
                result.setRepository(repo);
                break;
            }
        }
        return result;
    }

    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
        super.add(session, request);
        if (!request.getArtifact().isSnapshot() && ((Boolean)session.getConfigProperties().get(PROPERTY_UPDATE_RELEASES)).booleanValue()) {
            String path = this.getPathForArtifact(request.getArtifact(), request.getRepository() == null);
            File artifactFile = new File(this.getRepository().getBasedir(), path);
            File trackingFile = this.getTrackingFile(artifactFile);
            String repoId = request.getRepository() == null ? "" : request.getRepository().getId();
            HashMap<String, String> updates = new HashMap<String, String>();
            updates.put(artifactFile.getName() + ">" + repoId, "");
            this.trackingFileManager.update(trackingFile, updates);
        }
    }

    private File getTrackingFile(File artifactFile) {
        return new File(artifactFile.getParentFile(), this.trackingFilename);
    }
}

