/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Channel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.lang.Nullable;

public final class ConsumerChannelRegistry {
    private static final Log logger = LogFactory.getLog(ConsumerChannelRegistry.class);
    private static final ThreadLocal<ChannelHolder> consumerChannel = new ThreadLocal();

    private ConsumerChannelRegistry() {
    }

    public static void registerConsumerChannel(Channel channel, ConnectionFactory connectionFactory) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering consumer channel" + String.valueOf(channel) + " from factory " + String.valueOf(connectionFactory)));
        }
        consumerChannel.set(new ChannelHolder(channel, connectionFactory));
    }

    public static void unRegisterConsumerChannel() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unregistering consumer channel" + String.valueOf(consumerChannel.get())));
        }
        consumerChannel.remove();
    }

    @Nullable
    public static Channel getConsumerChannel() {
        ChannelHolder channelHolder = consumerChannel.get();
        return channelHolder != null ? channelHolder.getChannel() : null;
    }

    @Nullable
    public static Channel getConsumerChannel(ConnectionFactory connectionFactory) {
        ChannelHolder channelHolder = consumerChannel.get();
        Channel channel = null;
        if (channelHolder != null && channelHolder.getConnectionFactory().equals(connectionFactory)) {
            channel = channelHolder.getChannel();
        }
        return channel;
    }

    private static final class ChannelHolder {
        private final Channel channel;
        private final ConnectionFactory connectionFactory;

        ChannelHolder(Channel channel, ConnectionFactory connectionFactory) {
            this.channel = channel;
            this.connectionFactory = connectionFactory;
        }

        private Channel getChannel() {
            return this.channel;
        }

        private ConnectionFactory getConnectionFactory() {
            return this.connectionFactory;
        }
    }
}

