/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import org.springframework.batch.item.database.support.AbstractSqlPagingQueryProvider;
import org.springframework.batch.item.database.support.SqlPagingQueryUtils;

public class H2PagingQueryProvider
extends AbstractSqlPagingQueryProvider {
    @Override
    public String generateFirstPageQuery(int pageSize) {
        return SqlPagingQueryUtils.generateLimitSqlQuery(this, false, this.buildLimitClause(pageSize));
    }

    @Override
    public String generateRemainingPagesQuery(int pageSize) {
        return SqlPagingQueryUtils.generateLimitSqlQuery(this, true, this.buildLimitClause(pageSize));
    }

    private String buildLimitClause(int pageSize) {
        return "FETCH NEXT " + pageSize + " ROWS ONLY";
    }

    @Override
    public String generateJumpToItemQuery(int itemIndex, int pageSize) {
        int page = itemIndex / pageSize;
        int offset = page * pageSize - 1;
        offset = offset < 0 ? 0 : offset;
        String limitClause = "OFFSET " + offset + " ROWS FETCH NEXT 1 ROWS ONLY";
        return SqlPagingQueryUtils.generateLimitJumpToQuery(this, limitClause);
    }
}

