/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.jms.builder;

import org.springframework.batch.item.jms.JmsItemReader;
import org.springframework.jms.core.JmsOperations;
import org.springframework.util.Assert;

public class JmsItemReaderBuilder<T> {
    protected Class<? extends T> itemType;
    protected JmsOperations jmsTemplate;

    public JmsItemReaderBuilder<T> jmsTemplate(JmsOperations jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
        return this;
    }

    public JmsItemReaderBuilder<T> itemType(Class<? extends T> itemType) {
        this.itemType = itemType;
        return this;
    }

    public JmsItemReader<T> build() {
        Assert.notNull((Object)this.jmsTemplate, (String)"jmsTemplate is required.");
        JmsItemReader<? extends T> jmsItemReader = new JmsItemReader<T>();
        jmsItemReader.setItemType(this.itemType);
        jmsItemReader.setJmsTemplate(this.jmsTemplate);
        return jmsItemReader;
    }
}

