/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.io;

import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import org.springframework.util.Assert;

public final class FilePermissions {
    private FilePermissions() {
    }

    public static int posixPermissionsToUmask(Collection<PosixFilePermission> permissions) {
        Assert.notNull(permissions, (String)"Permissions must not be null");
        int owner = FilePermissions.permissionToUmask(permissions, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ);
        int group = FilePermissions.permissionToUmask(permissions, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_READ);
        int other = FilePermissions.permissionToUmask(permissions, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_READ);
        return Integer.parseInt("" + owner + group + other, 8);
    }

    private static int permissionToUmask(Collection<PosixFilePermission> permissions, PosixFilePermission execute, PosixFilePermission write, PosixFilePermission read) {
        int value = 0;
        if (permissions.contains((Object)execute)) {
            ++value;
        }
        if (permissions.contains((Object)write)) {
            value += 2;
        }
        if (permissions.contains((Object)read)) {
            value += 4;
        }
        return value;
    }
}

