/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.socket;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.springframework.boot.buildpack.platform.socket.AbstractSocket;
import org.springframework.boot.buildpack.platform.socket.BsdDomainSocket;
import org.springframework.boot.buildpack.platform.socket.FileDescriptor;
import org.springframework.boot.buildpack.platform.socket.LinuxDomainSocket;

public abstract class DomainSocket
extends AbstractSocket {
    private static final int SHUT_RD = 0;
    private static final int SHUT_WR = 1;
    protected static final int PF_LOCAL = 1;
    protected static final byte AF_LOCAL = 1;
    protected static final int SOCK_STREAM = 1;
    private final FileDescriptor fileDescriptor;
    private final InputStream inputStream;
    private final OutputStream outputStream;

    DomainSocket(String path) throws IOException {
        try {
            this.fileDescriptor = this.open(path);
            this.inputStream = new DomainSocketInputStream();
            this.outputStream = new DomainSocketOutputStream();
        }
        catch (LastErrorException ex) {
            throw new IOException(ex);
        }
    }

    private FileDescriptor open(String path) {
        int handle = this.socket(1, 1, 0);
        try {
            this.connect(path, handle);
            return new FileDescriptor(handle, this::close);
        }
        catch (RuntimeException ex) {
            this.close(handle);
            throw ex;
        }
    }

    private int read(ByteBuffer buffer) throws IOException {
        try (FileDescriptor.Handle handle = this.fileDescriptor.acquire();){
            if (handle.isClosed()) {
                int n = -1;
                return n;
            }
            int n = this.read(handle.intValue(), buffer, buffer.remaining());
            return n;
        }
    }

    public void write(ByteBuffer buffer) throws IOException {
        block8: {
            try (FileDescriptor.Handle handle = this.fileDescriptor.acquire();){
                if (handle.isClosed()) break block8;
                try {
                    this.write(handle.intValue(), buffer, buffer.remaining());
                }
                catch (LastErrorException ex) {
                    throw new IOException(ex);
                }
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            this.fileDescriptor.close();
        }
        catch (LastErrorException ex) {
            throw new IOException(ex);
        }
    }

    protected abstract void connect(String var1, int var2);

    private native int socket(int var1, int var2, int var3) throws LastErrorException;

    private native int read(int var1, ByteBuffer var2, int var3) throws LastErrorException;

    private native int write(int var1, ByteBuffer var2, int var3) throws LastErrorException;

    private native int close(int var1) throws LastErrorException;

    public static DomainSocket get(String path) throws IOException {
        if (Platform.isMac() || DomainSocket.isBsdPlatform()) {
            return new BsdDomainSocket(path);
        }
        return new LinuxDomainSocket(path);
    }

    private static boolean isBsdPlatform() {
        return Platform.isFreeBSD() || Platform.iskFreeBSD() || Platform.isNetBSD() || Platform.isOpenBSD();
    }

    static {
        Native.register((String)Platform.C_LIBRARY_NAME);
    }

    private final class DomainSocketInputStream
    extends InputStream {
        private DomainSocketInputStream() {
        }

        @Override
        public int read() throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(1);
            int amountRead = DomainSocket.this.read(buffer);
            return amountRead != 1 ? -1 : buffer.get() & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            int amountRead = DomainSocket.this.read(ByteBuffer.wrap(b, off, len));
            return amountRead > 0 ? amountRead : -1;
        }
    }

    private final class DomainSocketOutputStream
    extends OutputStream {
        private DomainSocketOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(1);
            buffer.put(0, (byte)(b & 0xFF));
            DomainSocket.this.write(buffer);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len != 0) {
                DomainSocket.this.write(ByteBuffer.wrap(b, off, len));
            }
        }
    }
}

