/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.configuration;

import java.util.function.BiConsumer;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerRegistryConfigAuthentication;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerRegistryTokenAuthentication;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerRegistryUserAuthentication;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.util.Assert;

@FunctionalInterface
public interface DockerRegistryAuthentication {
    public static final DockerRegistryAuthentication EMPTY_USER = DockerRegistryAuthentication.user("", "", "", "");

    default public String getAuthHeader(ImageReference imageReference) {
        return this.getAuthHeader();
    }

    public String getAuthHeader();

    public static DockerRegistryAuthentication token(String identityToken) {
        return new DockerRegistryTokenAuthentication(identityToken);
    }

    public static DockerRegistryAuthentication user(String username, String password, String serverAddress, String email) {
        return new DockerRegistryUserAuthentication(username, password, serverAddress, email);
    }

    public static DockerRegistryAuthentication configuration(DockerRegistryAuthentication fallback) {
        return DockerRegistryAuthentication.configuration(fallback, (message, ex) -> System.out.println((String)message));
    }

    public static DockerRegistryAuthentication configuration(DockerRegistryAuthentication fallback, BiConsumer<String, Exception> credentialHelperExceptionHandler) {
        Assert.notNull(credentialHelperExceptionHandler, () -> "'credentialHelperExceptionHandler' must not be null");
        return new DockerRegistryConfigAuthentication(fallback, credentialHelperExceptionHandler);
    }
}

