/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.io.File;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.build.BuildpackReference;
import org.springframework.boot.buildpack.platform.build.Cache;
import org.springframework.boot.buildpack.platform.build.Creator;
import org.springframework.boot.buildpack.platform.build.PullPolicy;
import org.springframework.boot.buildpack.platform.docker.type.Binding;
import org.springframework.boot.buildpack.platform.docker.type.ImagePlatform;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.io.Owner;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.util.Assert;

public class BuildRequest {
    static final String DEFAULT_BUILDER_IMAGE_NAME = "paketobuildpacks/builder-noble-java-tiny";
    static final String DEFAULT_BUILDER_IMAGE_REF = "paketobuildpacks/builder-noble-java-tiny:latest";
    static final List<ImageReference> KNOWN_TRUSTED_BUILDERS = List.of(ImageReference.of("paketobuildpacks/builder-noble-java-tiny"), ImageReference.of("paketobuildpacks/builder-jammy-java-tiny"), ImageReference.of("paketobuildpacks/builder-jammy-tiny"), ImageReference.of("paketobuildpacks/builder-jammy-base"), ImageReference.of("paketobuildpacks/builder-jammy-full"), ImageReference.of("paketobuildpacks/builder-jammy-buildpackless-tiny"), ImageReference.of("paketobuildpacks/builder-jammy-buildpackless-base"), ImageReference.of("paketobuildpacks/builder-jammy-buildpackless-full"), ImageReference.of("gcr.io/buildpacks/builder"), ImageReference.of("heroku/builder"));
    private static final ImageReference DEFAULT_BUILDER = ImageReference.of("paketobuildpacks/builder-noble-java-tiny:latest");
    private final ImageReference name;
    private final Function<Owner, TarArchive> applicationContent;
    private final ImageReference builder;
    private final @Nullable Boolean trustBuilder;
    private final @Nullable ImageReference runImage;
    private final Creator creator;
    private final Map<String, String> env;
    private final boolean cleanCache;
    private final boolean verboseLogging;
    private final PullPolicy pullPolicy;
    private final boolean publish;
    private final List<BuildpackReference> buildpacks;
    private final List<Binding> bindings;
    private final @Nullable String network;
    private final List<ImageReference> tags;
    private final @Nullable Cache buildWorkspace;
    private final @Nullable Cache buildCache;
    private final @Nullable Cache launchCache;
    private final @Nullable Instant createdDate;
    private final @Nullable String applicationDirectory;
    private final @Nullable List<String> securityOptions;
    private final @Nullable ImagePlatform platform;

    BuildRequest(ImageReference name, Function<Owner, TarArchive> applicationContent) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        Assert.notNull(applicationContent, (String)"'applicationContent' must not be null");
        this.name = name.inTaggedForm();
        this.applicationContent = applicationContent;
        this.builder = DEFAULT_BUILDER;
        this.trustBuilder = null;
        this.runImage = null;
        this.env = Collections.emptyMap();
        this.cleanCache = false;
        this.verboseLogging = false;
        this.pullPolicy = PullPolicy.ALWAYS;
        this.publish = false;
        this.creator = Creator.withVersion("");
        this.buildpacks = Collections.emptyList();
        this.bindings = Collections.emptyList();
        this.network = null;
        this.tags = Collections.emptyList();
        this.buildWorkspace = null;
        this.buildCache = null;
        this.launchCache = null;
        this.createdDate = null;
        this.applicationDirectory = null;
        this.securityOptions = null;
        this.platform = null;
    }

    BuildRequest(ImageReference name, Function<Owner, TarArchive> applicationContent, ImageReference builder, @Nullable Boolean trustBuilder, @Nullable ImageReference runImage, Creator creator, Map<String, String> env, boolean cleanCache, boolean verboseLogging, PullPolicy pullPolicy, boolean publish, List<BuildpackReference> buildpacks, List<Binding> bindings, @Nullable String network, List<ImageReference> tags, @Nullable Cache buildWorkspace, @Nullable Cache buildCache, @Nullable Cache launchCache, @Nullable Instant createdDate, @Nullable String applicationDirectory, @Nullable List<String> securityOptions, @Nullable ImagePlatform platform) {
        this.name = name;
        this.applicationContent = applicationContent;
        this.builder = builder;
        this.trustBuilder = trustBuilder;
        this.runImage = runImage;
        this.creator = creator;
        this.env = env;
        this.cleanCache = cleanCache;
        this.verboseLogging = verboseLogging;
        this.pullPolicy = pullPolicy;
        this.publish = publish;
        this.buildpacks = buildpacks;
        this.bindings = bindings;
        this.network = network;
        this.tags = tags;
        this.buildWorkspace = buildWorkspace;
        this.buildCache = buildCache;
        this.launchCache = launchCache;
        this.createdDate = createdDate;
        this.applicationDirectory = applicationDirectory;
        this.securityOptions = securityOptions;
        this.platform = platform;
    }

    public BuildRequest withBuilder(ImageReference builder) {
        Assert.notNull((Object)builder, (String)"'builder' must not be null");
        return new BuildRequest(this.name, this.applicationContent, builder.inTaggedOrDigestForm(), this.trustBuilder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks, this.bindings, this.network, this.tags, this.buildWorkspace, this.buildCache, this.launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withTrustBuilder(boolean trustBuilder) {
        return new BuildRequest(this.name, this.applicationContent, this.builder, trustBuilder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks, this.bindings, this.network, this.tags, this.buildWorkspace, this.buildCache, this.launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withRunImage(ImageReference runImageName) {
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, runImageName.inTaggedOrDigestForm(), this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks, this.bindings, this.network, this.tags, this.buildWorkspace, this.buildCache, this.launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withCreator(Creator creator) {
        Assert.notNull((Object)creator, (String)"'creator' must not be null");
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks, this.bindings, this.network, this.tags, this.buildWorkspace, this.buildCache, this.launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withEnv(String name, String value) {
        Assert.hasText((String)name, (String)"'name' must not be empty");
        Assert.hasText((String)value, (String)"'value' must not be empty");
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>(this.env);
        env.put(name, value);
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, this.creator, Collections.unmodifiableMap(env), this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks, this.bindings, this.network, this.tags, this.buildWorkspace, this.buildCache, this.launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withEnv(Map<String, String> env) {
        Assert.notNull(env, (String)"'env' must not be null");
        LinkedHashMap<String, String> updatedEnv = new LinkedHashMap<String, String>(this.env);
        updatedEnv.putAll(env);
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, this.creator, Collections.unmodifiableMap(updatedEnv), this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks, this.bindings, this.network, this.tags, this.buildWorkspace, this.buildCache, this.launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withCleanCache(boolean cleanCache) {
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, this.creator, this.env, cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks, this.bindings, this.network, this.tags, this.buildWorkspace, this.buildCache, this.launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withVerboseLogging(boolean verboseLogging) {
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, this.creator, this.env, this.cleanCache, verboseLogging, this.pullPolicy, this.publish, this.buildpacks, this.bindings, this.network, this.tags, this.buildWorkspace, this.buildCache, this.launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withPullPolicy(PullPolicy pullPolicy) {
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, pullPolicy, this.publish, this.buildpacks, this.bindings, this.network, this.tags, this.buildWorkspace, this.buildCache, this.launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withPublish(boolean publish) {
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, publish, this.buildpacks, this.bindings, this.network, this.tags, this.buildWorkspace, this.buildCache, this.launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withBuildpacks(BuildpackReference ... buildpacks) {
        Assert.notEmpty((Object[])buildpacks, (String)"'buildpacks' must not be empty");
        return this.withBuildpacks(Arrays.asList(buildpacks));
    }

    public BuildRequest withBuildpacks(List<BuildpackReference> buildpacks) {
        Assert.notNull(buildpacks, (String)"'buildpacks' must not be null");
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, buildpacks, this.bindings, this.network, this.tags, this.buildWorkspace, this.buildCache, this.launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withBindings(Binding ... bindings) {
        Assert.notEmpty((Object[])bindings, (String)"'bindings' must not be empty");
        return this.withBindings(Arrays.asList(bindings));
    }

    public BuildRequest withBindings(List<Binding> bindings) {
        Assert.notNull(bindings, (String)"'bindings' must not be null");
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks, bindings, this.network, this.tags, this.buildWorkspace, this.buildCache, this.launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withNetwork(@Nullable String network) {
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks, this.bindings, network, this.tags, this.buildWorkspace, this.buildCache, this.launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withTags(ImageReference ... tags) {
        Assert.notEmpty((Object[])tags, (String)"'tags' must not be empty");
        return this.withTags(Arrays.asList(tags));
    }

    public BuildRequest withTags(List<ImageReference> tags) {
        Assert.notNull(tags, (String)"'tags' must not be null");
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks, this.bindings, this.network, tags, this.buildWorkspace, this.buildCache, this.launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withBuildWorkspace(Cache buildWorkspace) {
        Assert.notNull((Object)buildWorkspace, (String)"'buildWorkspace' must not be null");
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks, this.bindings, this.network, this.tags, buildWorkspace, this.buildCache, this.launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withBuildCache(Cache buildCache) {
        Assert.notNull((Object)buildCache, (String)"'buildCache' must not be null");
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks, this.bindings, this.network, this.tags, this.buildWorkspace, buildCache, this.launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withLaunchCache(Cache launchCache) {
        Assert.notNull((Object)launchCache, (String)"'launchCache' must not be null");
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks, this.bindings, this.network, this.tags, this.buildWorkspace, this.buildCache, launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withCreatedDate(String createdDate) {
        Assert.notNull((Object)createdDate, (String)"'createdDate' must not be null");
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks, this.bindings, this.network, this.tags, this.buildWorkspace, this.buildCache, this.launchCache, this.parseCreatedDate(createdDate), this.applicationDirectory, this.securityOptions, this.platform);
    }

    private Instant parseCreatedDate(String createdDate) {
        if ("now".equalsIgnoreCase(createdDate)) {
            return Instant.now();
        }
        try {
            return Instant.parse(createdDate);
        }
        catch (DateTimeParseException ex) {
            throw new IllegalArgumentException("Error parsing '" + createdDate + "' as an image created date", ex);
        }
    }

    public BuildRequest withApplicationDirectory(String applicationDirectory) {
        Assert.notNull((Object)applicationDirectory, (String)"'applicationDirectory' must not be null");
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks, this.bindings, this.network, this.tags, this.buildWorkspace, this.buildCache, this.launchCache, this.createdDate, applicationDirectory, this.securityOptions, this.platform);
    }

    public BuildRequest withSecurityOptions(List<String> securityOptions) {
        Assert.notNull(securityOptions, (String)"'securityOptions' must not be null");
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks, this.bindings, this.network, this.tags, this.buildWorkspace, this.buildCache, this.launchCache, this.createdDate, this.applicationDirectory, securityOptions, this.platform);
    }

    public BuildRequest withImagePlatform(String platform) {
        Assert.notNull((Object)platform, (String)"'platform' must not be null");
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.trustBuilder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks, this.bindings, this.network, this.tags, this.buildWorkspace, this.buildCache, this.launchCache, this.createdDate, this.applicationDirectory, this.securityOptions, ImagePlatform.of(platform));
    }

    public ImageReference getName() {
        return this.name;
    }

    public TarArchive getApplicationContent(Owner owner) {
        return this.applicationContent.apply(owner);
    }

    public ImageReference getBuilder() {
        return this.builder;
    }

    public boolean isTrustBuilder() {
        return this.trustBuilder != null ? this.trustBuilder.booleanValue() : this.isBuilderKnownAndTrusted();
    }

    private boolean isBuilderKnownAndTrusted() {
        return KNOWN_TRUSTED_BUILDERS.stream().anyMatch(builder -> builder.getName().equals(this.builder.getName()));
    }

    public @Nullable ImageReference getRunImage() {
        return this.runImage;
    }

    public Creator getCreator() {
        return this.creator;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public boolean isCleanCache() {
        return this.cleanCache;
    }

    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public boolean isPublish() {
        return this.publish;
    }

    public PullPolicy getPullPolicy() {
        return this.pullPolicy;
    }

    public List<BuildpackReference> getBuildpacks() {
        return this.buildpacks;
    }

    public List<Binding> getBindings() {
        return this.bindings;
    }

    public @Nullable String getNetwork() {
        return this.network;
    }

    public List<ImageReference> getTags() {
        return this.tags;
    }

    public @Nullable Cache getBuildWorkspace() {
        return this.buildWorkspace;
    }

    public @Nullable Cache getBuildCache() {
        return this.buildCache;
    }

    public @Nullable Cache getLaunchCache() {
        return this.launchCache;
    }

    public @Nullable Instant getCreatedDate() {
        return this.createdDate;
    }

    public @Nullable String getApplicationDirectory() {
        return this.applicationDirectory;
    }

    public @Nullable List<String> getSecurityOptions() {
        return this.securityOptions;
    }

    public @Nullable ImagePlatform getImagePlatform() {
        return this.platform;
    }

    public static BuildRequest forJarFile(File jarFile) {
        BuildRequest.assertJarFile(jarFile);
        return BuildRequest.forJarFile(ImageReference.forJarFile(jarFile).inTaggedForm(), jarFile);
    }

    public static BuildRequest forJarFile(ImageReference name, File jarFile) {
        BuildRequest.assertJarFile(jarFile);
        return new BuildRequest(name, owner -> TarArchive.fromZip(jarFile, owner));
    }

    public static BuildRequest of(ImageReference name, Function<Owner, TarArchive> applicationContent) {
        return new BuildRequest(name, applicationContent);
    }

    private static void assertJarFile(File jarFile) {
        Assert.notNull((Object)jarFile, (String)"'jarFile' must not be null");
        Assert.isTrue((boolean)jarFile.exists(), (String)"'jarFile' must exist");
        Assert.isTrue((boolean)jarFile.isFile(), (String)"'jarFile' must be a file");
    }
}

