/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.build.BuildpackMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.tomlj.Toml;
import org.tomlj.TomlParseResult;

final class BuildpackCoordinates {
    private final String id;
    private final @Nullable String version;

    private BuildpackCoordinates(String id, @Nullable String version) {
        Assert.hasText((String)id, (String)"'id' must not be empty");
        this.id = id;
        this.version = version;
    }

    String getId() {
        return this.id;
    }

    String getSanitizedId() {
        return this.id.replace("/", "_");
    }

    @Nullable String getVersion() {
        return this.version;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BuildpackCoordinates other = (BuildpackCoordinates)obj;
        return this.id.equals(other.id) && ObjectUtils.nullSafeEquals((Object)this.version, (Object)other.version);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.version);
        return result;
    }

    public String toString() {
        return this.id + (String)(StringUtils.hasText((String)this.version) ? "@" + this.version : "");
    }

    static BuildpackCoordinates fromToml(InputStream inputStream, Path path) throws IOException {
        return BuildpackCoordinates.fromToml(Toml.parse((InputStream)inputStream), path);
    }

    private static BuildpackCoordinates fromToml(TomlParseResult toml, Path path) {
        Assert.isTrue((!toml.isEmpty() ? 1 : 0) != 0, () -> "Buildpack descriptor 'buildpack.toml' is required in buildpack '" + String.valueOf(path) + "'");
        Assert.hasText((String)toml.getString("buildpack.id"), () -> "Buildpack descriptor must contain ID in buildpack '" + String.valueOf(path) + "'");
        Assert.hasText((String)toml.getString("buildpack.version"), () -> "Buildpack descriptor must contain version in buildpack '" + String.valueOf(path) + "'");
        Assert.isTrue((toml.contains("stacks") || toml.contains("order") ? 1 : 0) != 0, () -> "Buildpack descriptor must contain either 'stacks' or 'order' in buildpack '" + String.valueOf(path) + "'");
        Assert.isTrue((!toml.contains("stacks") || !toml.contains("order") ? 1 : 0) != 0, () -> "Buildpack descriptor must not contain both 'stacks' and 'order' in buildpack '" + String.valueOf(path) + "'");
        return new BuildpackCoordinates(toml.getString("buildpack.id"), toml.getString("buildpack.version"));
    }

    static BuildpackCoordinates fromBuildpackMetadata(BuildpackMetadata buildpackMetadata) {
        Assert.notNull((Object)buildpackMetadata, (String)"'buildpackMetadata' must not be null");
        return new BuildpackCoordinates(buildpackMetadata.getId(), buildpackMetadata.getVersion());
    }

    static BuildpackCoordinates of(String id, String version) {
        return new BuildpackCoordinates(id, version);
    }
}

