/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.toolchain.ToolchainManager;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.loader.tools.RunProcess;
import org.springframework.boot.maven.AbstractRunMojo;
import org.springframework.boot.maven.JavaProcessExecutor;
import org.springframework.boot.maven.RunArguments;
import org.springframework.boot.maven.SpringApplicationAdminClient;

@Mojo(name="start", requiresProject=true, defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class StartMojo
extends AbstractRunMojo {
    private static final String ENABLE_MBEAN_PROPERTY = "--spring.application.admin.enabled=true";
    private static final String JMX_NAME_PROPERTY_PREFIX = "--spring.application.admin.jmx-name=";
    @Parameter(defaultValue="org.springframework.boot:type=Admin,name=SpringApplication")
    private String jmxName;
    @Parameter(defaultValue="9001")
    private int jmxPort;
    @Parameter(property="spring-boot.start.wait", defaultValue="500")
    private long wait;
    @Parameter(property="spring-boot.start.maxAttempts", defaultValue="60")
    private int maxAttempts;
    private final Object lock = new Object();
    @Parameter(property="spring-boot.run.useTestClasspath", defaultValue="false")
    private boolean useTestClasspath;

    @Inject
    public StartMojo(ToolchainManager toolchainManager) {
        super(toolchainManager);
    }

    @Override
    protected void run(JavaProcessExecutor processExecutor, File workingDirectory, List<String> args, Map<String, String> environmentVariables) throws MojoExecutionException, MojoFailureException {
        RunProcess runProcess = processExecutor.runAsync(workingDirectory, args, environmentVariables);
        try {
            this.waitForSpringApplication();
        }
        catch (MojoExecutionException | MojoFailureException ex) {
            runProcess.kill();
            throw ex;
        }
    }

    @Override
    protected RunArguments resolveApplicationArguments() {
        RunArguments applicationArguments = super.resolveApplicationArguments();
        applicationArguments.getArgs().addLast(ENABLE_MBEAN_PROPERTY);
        applicationArguments.getArgs().addLast(JMX_NAME_PROPERTY_PREFIX + this.jmxName);
        return applicationArguments;
    }

    @Override
    protected RunArguments resolveJvmArguments() {
        RunArguments jvmArguments = super.resolveJvmArguments();
        ArrayList<Object> remoteJmxArguments = new ArrayList<Object>();
        remoteJmxArguments.add("-Dcom.sun.management.jmxremote");
        remoteJmxArguments.add("-Dcom.sun.management.jmxremote.port=" + this.jmxPort);
        remoteJmxArguments.add("-Dcom.sun.management.jmxremote.authenticate=false");
        remoteJmxArguments.add("-Dcom.sun.management.jmxremote.ssl=false");
        remoteJmxArguments.add("-Djava.rmi.server.hostname=127.0.0.1");
        jvmArguments.getArgs().addAll(remoteJmxArguments);
        return jvmArguments;
    }

    private void waitForSpringApplication() throws MojoFailureException, MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)("Connecting to local MBeanServer at port " + this.jmxPort));
            try (JMXConnector connector = this.execute(this.wait, this.maxAttempts, new CreateJmxConnector(this.jmxPort));){
                if (connector == null) {
                    throw new MojoExecutionException("JMX MBean server was not reachable before the configured timeout (" + this.wait * (long)this.maxAttempts + "ms");
                }
                this.getLog().debug((CharSequence)("Connected to local MBeanServer at port " + this.jmxPort));
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                this.doWaitForSpringApplication(connection);
            }
        }
        catch (IOException ex) {
            throw new MojoFailureException("Could not contact Spring Boot application via JMX on port " + this.jmxPort + ". Please make sure that no other process is using that port", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Failed to connect to MBean server at port " + this.jmxPort, ex);
        }
    }

    private void doWaitForSpringApplication(MBeanServerConnection connection) throws MojoExecutionException, MojoFailureException {
        SpringApplicationAdminClient client = new SpringApplicationAdminClient(connection, this.jmxName);
        try {
            this.execute(this.wait, this.maxAttempts, () -> client.isReady() ? Boolean.valueOf(true) : null);
        }
        catch (ReflectionException ex) {
            throw new MojoExecutionException("Unable to retrieve 'ready' attribute", ex.getCause());
        }
        catch (Exception ex) {
            throw new MojoFailureException("Could not invoke shutdown operation", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(long wait, int maxAttempts, Callable<@Nullable T> callback) throws Exception {
        this.getLog().debug((CharSequence)"Waiting for spring application to start...");
        for (int i = 0; i < maxAttempts; ++i) {
            T result = callback.call();
            if (result != null) {
                return result;
            }
            String message = "Spring application is not ready yet, waiting " + wait + "ms (attempt " + (i + 1) + ")";
            this.getLog().debug((CharSequence)message);
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(wait);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Interrupted while waiting for Spring Boot app to start.");
                }
            }
        }
        throw new MojoExecutionException("Spring application did not start before the configured timeout (" + wait * (long)maxAttempts + "ms");
    }

    @Override
    protected boolean isUseTestClasspath() {
        return this.useTestClasspath;
    }

    private class CreateJmxConnector
    implements Callable<JMXConnector> {
        private final int port;

        CreateJmxConnector(int port) {
            this.port = port;
        }

        @Override
        public @Nullable JMXConnector call() throws Exception {
            try {
                return SpringApplicationAdminClient.connect(this.port);
            }
            catch (IOException ex) {
                if (this.hasCauseWithType(ex, ConnectException.class)) {
                    String message = "MBean server at port " + this.port + " is not up yet...";
                    StartMojo.this.getLog().debug((CharSequence)message);
                    return null;
                }
                throw ex;
            }
        }

        private boolean hasCauseWithType(Throwable t, Class<? extends Exception> type) {
            return type.isAssignableFrom(t.getClass()) || t.getCause() != null && this.hasCauseWithType(t.getCause(), type);
        }
    }
}

