/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.actuate.endpoint.web;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.EndpointAccessResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.annotation.ExposableControllerEndpoint;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.mvc.condition.PathPatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

@Deprecated(since="3.3.5", forRemoval=true)
public class ControllerEndpointHandlerMapping
extends RequestMappingHandlerMapping {
    private static final Set<RequestMethod> READ_ONLY_ACCESS_REQUEST_METHODS = EnumSet.of(RequestMethod.GET, RequestMethod.HEAD);
    private final EndpointMapping endpointMapping;
    private final @Nullable CorsConfiguration corsConfiguration;
    private final Map<Object, ExposableControllerEndpoint> handlers;
    private final EndpointAccessResolver accessResolver;

    public ControllerEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<ExposableControllerEndpoint> endpoints, @Nullable CorsConfiguration corsConfiguration) {
        this(endpointMapping, endpoints, corsConfiguration, (endpointId, defaultAccess) -> Access.NONE);
    }

    public ControllerEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<ExposableControllerEndpoint> endpoints, @Nullable CorsConfiguration corsConfiguration, EndpointAccessResolver endpointAccessResolver) {
        Assert.notNull((Object)endpointMapping, (String)"'endpointMapping' must not be null");
        Assert.notNull(endpoints, (String)"'endpoints' must not be null");
        this.endpointMapping = endpointMapping;
        this.handlers = this.getHandlers(endpoints);
        this.corsConfiguration = corsConfiguration;
        this.accessResolver = endpointAccessResolver;
        this.setOrder(-100);
    }

    private Map<Object, ExposableControllerEndpoint> getHandlers(Collection<ExposableControllerEndpoint> endpoints) {
        LinkedHashMap handlers = new LinkedHashMap();
        endpoints.forEach(endpoint -> handlers.put(endpoint.getController(), endpoint));
        return Collections.unmodifiableMap(handlers);
    }

    protected void initHandlerMethods() {
        ControllerEndpointHandlerMapping controllerEndpointHandlerMapping = this;
        this.handlers.keySet().forEach(x$0 -> controllerEndpointHandlerMapping.detectHandlerMethods(x$0));
    }

    protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
        ExposableControllerEndpoint endpoint = this.handlers.get(handler);
        Assert.state((endpoint != null ? 1 : 0) != 0, (String)"'endpoint' must not be null");
        Access access = this.accessResolver.accessFor(endpoint.getEndpointId(), endpoint.getDefaultAccess());
        if (access == Access.NONE) {
            return;
        }
        if (access == Access.READ_ONLY && CollectionUtils.isEmpty((Collection)(mapping = this.withReadOnlyAccess(access, mapping)).getMethodsCondition().getMethods())) {
            return;
        }
        mapping = this.withEndpointMappedPatterns(endpoint, mapping);
        super.registerHandlerMethod(handler, method, mapping);
    }

    private RequestMappingInfo withReadOnlyAccess(Access access, RequestMappingInfo mapping) {
        Set methods = mapping.getMethodsCondition().getMethods();
        HashSet<RequestMethod> modifiedMethods = new HashSet<RequestMethod>(methods);
        if (modifiedMethods.isEmpty()) {
            modifiedMethods.addAll(READ_ONLY_ACCESS_REQUEST_METHODS);
        } else {
            modifiedMethods.retainAll(READ_ONLY_ACCESS_REQUEST_METHODS);
        }
        return mapping.mutate().methods(modifiedMethods.toArray(new RequestMethod[0])).build();
    }

    private RequestMappingInfo withEndpointMappedPatterns(ExposableControllerEndpoint endpoint, RequestMappingInfo mapping) {
        PathPatternsRequestCondition condition = mapping.getPathPatternsCondition();
        Assert.state((condition != null ? 1 : 0) != 0, (String)"'condition' must not be null");
        Set<PathPattern> patterns = condition.getPatterns();
        if (patterns.isEmpty()) {
            PathPatternParser parser = this.getPatternParser();
            Assert.state((parser != null ? 1 : 0) != 0, (String)"'parser' must not be null");
            patterns = Collections.singleton(parser.parse(""));
        }
        String[] endpointMappedPatterns = (String[])patterns.stream().map(pattern -> this.getEndpointMappedPattern(endpoint, (PathPattern)pattern)).toArray(String[]::new);
        return mapping.mutate().paths(endpointMappedPatterns).build();
    }

    private String getEndpointMappedPattern(ExposableControllerEndpoint endpoint, PathPattern pattern) {
        return this.endpointMapping.createSubPath(endpoint.getRootPath() + String.valueOf(pattern));
    }

    protected boolean hasCorsConfigurationSource(Object handler) {
        return this.corsConfiguration != null;
    }

    protected @Nullable CorsConfiguration initCorsConfiguration(Object handler, Method method, RequestMappingInfo mapping) {
        return this.corsConfiguration;
    }
}

