/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.lang.reflect.Method;
import java.util.List;
import org.springframework.core.KotlinDetector;
import org.springframework.kafka.listener.adapter.ContinuationHandlerMethodArgumentResolver;
import org.springframework.kafka.listener.adapter.KafkaNullAwarePayloadArgumentResolver;
import org.springframework.kafka.listener.adapter.KotlinAwareInvocableHandlerMethod;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolverComposite;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.validation.Validator;

public class KafkaMessageHandlerMethodFactory
extends DefaultMessageHandlerMethodFactory {
    private final HandlerMethodArgumentResolverComposite argumentResolvers = new HandlerMethodArgumentResolverComposite();
    private MessageConverter messageConverter;
    private Validator validator;

    public void setMessageConverter(MessageConverter messageConverter) {
        super.setMessageConverter(messageConverter);
        this.messageConverter = messageConverter;
    }

    public void setValidator(Validator validator) {
        super.setValidator(validator);
        this.validator = validator;
    }

    protected List<HandlerMethodArgumentResolver> initArgumentResolvers() {
        List resolvers = super.initArgumentResolvers();
        if (KotlinDetector.isKotlinPresent()) {
            resolvers.add(resolvers.size() - 1, new ContinuationHandlerMethodArgumentResolver());
        }
        resolvers.add(resolvers.size() - 1, new KafkaNullAwarePayloadArgumentResolver(this.messageConverter, this.validator));
        this.argumentResolvers.addResolvers(resolvers);
        return resolvers;
    }

    public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
        KotlinAwareInvocableHandlerMethod handlerMethod = new KotlinAwareInvocableHandlerMethod(bean, method);
        handlerMethod.setMessageMethodArgumentResolvers(this.argumentResolvers);
        return handlerMethod;
    }
}

